package com.tykj.dev.device.sendback.service;

import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.sendback.entity.domain.DeviceRepel;
import com.tykj.dev.device.sendback.entity.domain.DeviceRepelDetail;
import com.tykj.dev.device.sendback.entity.vo.*;
import org.springframework.data.domain.Page;

import java.util.List;
import java.util.Map;

public interface RepelQueryService {
    /**
     * 省、市清退任务待各市提交查询接口
     */
    RepelStatisticsVo findRepelTaskStatisticals(Integer taskId, Integer billId);


    /**
     *  审核详情页面
      * @param taskId 任务id
     * @return 详情
     */
    DeviceRepelDetail findDeviceRepelDetail(Integer taskId);


    /**
     * 通知页面的查询接口
     */
    DeviceRepel findDeviceRepel(Integer taskId);


    /**
     * 根据列装id,以及当前用户
     */
    DeviceChooseRepel findDeviceChooseRepel(DeviceChoosePageVo deviceChoosePageVo);

    /**
     * 根据列装id,以及当前用户 查询提交装备的ID集合
     */
    List<Integer> findIdList(DeviceChoosePageVo deviceChoosePageVo);

    /**
     * 区县出库界面查询接口 根据taskid查询出库装备列表
     */
    List<DeviceLibrary> findDeviceSendOut(Integer taskId);


    /**
     * 待清退列表 省
     */
    List<ModelNameGroup> toRepelList(RepelManagementVo repelManagementVo);


    /**
     * 待清退列表 省
     */
    List<DeviceLibrary> toRepelListDev(RepelManagementVo repelManagementVo);

    /**
     * 待清退页面查询统计查询接口
     */
    List<DevRepelVo> findRepelListModelNameGroup(ModelAndTypeVo modelAndTypeVo);

    /**
     * 已清退列表
     */
    List<ModelNameGroup> clearedList(RepelManagementVo repelManagementVo);

    /**
     * 退役装备列表
     */
    List<ModelNameGroup> retiredList(RepelManagementVo repelManagementVo);

    /**
     *省直属任务装备查询接口
     */
    AllDirectUnderDevVo provinceDirectlyUnderDev(Integer taskId);

    /**
     * 查询直属单位列表
     */
    List<DirectlyUnderNavigation> directlyUnderUnitLeftNavigation(Integer taskId,Integer type);

    /**
     *省直属任务装备已选择装备列表接口
     */
    List<DeviceLibrary> provinceDirectlyUnderSelectedDev(Integer taskId,Integer unitId,Integer type);

    /**
     * 清退管理 列表数据点击查询接口
     */
    List<DevRepelVo> repelManagementListDetails(List<Integer> ids);

    /**
     查询清退单
     */
    Page<DeviceRepelDetail> getList(RepelDetailSelectVo repelDetailSelectVo);


    /**
     * 省自己装备清退列表查询的接口
     */
    DeviceChooseRepel findDeviceChooseRepel1(DeviceChoosePageVo deviceChoosePageVo);


    /**
     * 查看已清退装备列表
     */
    PagingVo clearedDeviceList(RepelManagementVo repelManagementVo);


    /**
     * 查看待清退装备列表
     */
    PagingVo repelDeviceList(RepelManagementVo repelManagementVo);

    /**
     * 查看待清退装备列表
     */
    PagingVo repelDeviceInList(RepelManagementVo repelManagementVo);

    /**
     * 根据业务ID查询清退业务详情
     */
    DeviceRepelDetail findByBillIdDeviceRepelDetail(Integer repelId);

    /**
     * 判断发起的列装是否需要提示
     */
    RepelFieldingPrompt judgeFieldingIsNotNormal(List<RepelFieldingVo> repelFieldingVoList);

    /**
     * 根据taskId查询相关文件接口（设备日志使用）
     */
    Map<String, List<FileRet>> findByTaskIdToFileMapList(Integer taskId);
}
