package com.tykj.dev.device.sendback.service.impl;

import com.tykj.dev.device.library.repository.DeviceLibraryDao;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.sendback.entity.domain.RepelDeviceUnit;
import com.tykj.dev.device.sendback.repository.RepelDeviceUnitDao;
import com.tykj.dev.device.sendback.service.RepelDeviceUnitService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName RepelDeviceUnitServiceImpl.java
 * @Description TODO
 * @createTime 2021年01月10日 10:52:00
 */
@Service
@Slf4j
public class RepelDeviceUnitServiceImpl implements RepelDeviceUnitService {
    @Autowired
    RepelDeviceUnitDao repelDeviceUnitDao;
    @Autowired
    DeviceLibraryDao deviceLibraryDao;
    @Override
    public RepelDeviceUnit saveRepelDeviceUnit(RepelDeviceUnit repelDeviceUnit) {
        return repelDeviceUnitDao.save(repelDeviceUnit);
    }

    @Override
    public void saveAllRepelDeviceUnit(List<RepelDeviceUnit> repelDeviceUnits) {
        repelDeviceUnitDao.saveAll(repelDeviceUnits);
    }

    @Override
    public List<DeviceLibrary> findHasRepel(Integer unitId) {
       List<Integer> ids= repelDeviceUnitDao.findAllByUnitsId(unitId).stream().map(RepelDeviceUnit::getDeviceId).collect(Collectors.toList());
        if (ids!=null&&ids.size()!=0) {
            return deviceLibraryDao.getDeviceLibraryEntitiesByIdIn(ids);
        }else {
            return new ArrayList<>();
        }
        }
}
