package com.tykj.dev.statistical.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.statistical.cache.BigScreenCache;
import com.tykj.dev.statistical.service.BigScreenService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author dengdiyi
 */
@RestController
@Api(tags = "大屏模块", description = "统计相关接口")
@AutoDocument
@RequestMapping("/bigScreen")
public class BigScreenController {

    @Autowired
    private BigScreenService bigScreenService;

    @Autowired
    private BigScreenCache bigScreenCache;

    /**
     * 查询省及各市的装备数量
     * @return 省及各市装备对象集合
     */
    @ApiOperation(value = "查询省及各市的装备数量")
    @GetMapping("/devNum")
    public ResponseEntity selectDevNum(){
        return ResponseEntity.ok(bigScreenCache.getDevNums());
    }

    @ApiOperation(value = "查询全省某业务每月数量统计")
    @GetMapping("/businessNum/{businessType}")
    public ResponseEntity selectbusinessNum(@PathVariable int businessType){
        if (businessType==2) {
            return ResponseEntity.ok(bigScreenCache.getBusinessNums());
        }
        else {
            return ResponseEntity.ok(bigScreenService.getBusinessNum(businessType));
        }
    }

    @ApiOperation(value = "查询大屏中心统计")
    @GetMapping("/center")
    public ResponseEntity selectCenterNum(){
        return ResponseEntity.ok(bigScreenCache.getCenterNum());
    }

    @ApiOperation(value = "查询装备维修情况数量统计")
    @GetMapping("/repairNum")
    public ResponseEntity selectRepairNum(){
        return ResponseEntity.ok(bigScreenCache.getRepairNum());
    }

    @ApiOperation(value = "查询装备维修情况装备统计")
    @GetMapping("/repairDevice")
    public ResponseEntity selectRepairDevice(){
        return ResponseEntity.ok(bigScreenCache.getRepairDevices());
    }

    @ApiOperation(value = "查询最近一次自查统计")
    @GetMapping("/selfCheck")
    public ResponseEntity selectSelfCheck(){
        return ResponseEntity.ok(bigScreenCache.getSelfCheckNums());
    }

    @ApiOperation(value = "查询专管员统计")
    @GetMapping("/user")
    public ResponseEntity selectUser(){
        return ResponseEntity.ok(bigScreenCache.getUserDateScreens());
    }
}
