package com.tykj.dev.device.storage.subject.vo;

import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.file.service.FilesUtil;
import com.tykj.dev.device.library.subject.vo.DeviceLibrarySaveVo;
import com.tykj.dev.device.storage.subject.domin.StorageBill;
import com.tykj.dev.misc.base.BeanHelper;
import com.tykj.dev.misc.utils.JacksonUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.modelmapper.ModelMapper;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("入库存储类")
public class StorageBillSaveVo {

    @Min(value = 1,message = "taskId不能小于1")
    @ApiModelProperty(value = "任务Id")
    private Integer taskId;

    @ApiModelProperty(value = "是否打印rfid标签(1:是，0:否)")
    private Integer isPrint = 0;

    @ApiModelProperty(value = "导入申请任务Id集合")
    private List<Integer> applyTaskIds;

//    @NotNull(message = "applyNumber不能为空")
    @ApiModelProperty(value = "申请文号")
    private String applyNumber;

//    @NotNull(message = "replayNumber不能为空")
    @ApiModelProperty(value = "批复文号")
    private String replayNumber;

    @NotNull(message = "sendUnit不能为空")
    @ApiModelProperty(value = "配送单位")
    private String sendUnit;

    @NotNull(message = "sendUserId不能为空")
    @ApiModelProperty(value = "发件方")
    private String sendUserId;

    @NotNull(message = "approver不能为空")
    @ApiModelProperty(value = "核发人")
    private String approver;

    @NotNull(message = "sendTime不能为空")
    @ApiModelProperty(value = "配发时间")
    private Date sendTime;

    @NotNull(message = "receiveUseraId不能为空")
    @Min(value = 1,message = "receiveUseraId不能小于1")
    @ApiModelProperty(value = "接收单位A岗")
    private Integer receiveUseraId;

    @NotNull(message = "receiveUserbId不能为空")
    @Min(value = 1,message = "receiveUserbId不能小于1")
    @ApiModelProperty(value = "接收单位B岗")
    private Integer receiveUserbId;

    @NotNull(message = "fileName不能为空")
    @ApiModelProperty(value = "配发单附件名")
    private String fileName;

    @NotNull(message = "fileUrl不能为空")
    @ApiModelProperty(value = "配发单附件url")
    private String fileUrl;

//    @NotNull(message = "fileName不能为空")
    @ApiModelProperty(value = "批复文号附件名")
    private List<FileRet> replyFiles;

    @ApiModelProperty(value = "申请文号附件名")
    private List<FileRet> applyFiles;

    @ApiModelProperty(value = "配发单附件")
    private List<FileRet> allotFiles;

//    @NotNull(message = "receiveFileName不能为空")
    @ApiModelProperty(value = "入库单附件名")
    private String receiveFileName;

//    @NotNull(message = "receiveFileUrl不能为空")
    @ApiModelProperty(value = "入库单附件url")
    private String receiveFileUrl;

//    @NotNull(message = "storagingCount不能为空")
//    @Min(value = 1,message = "storagingCount不能小于1")
    @ApiModelProperty(value = "待入库数量")
    private Integer storagingCount;

//    @NotNull(message = "storagedCount不能为空")
//    @Min(value = 0,message = "storagedCount不能小于0")
    @ApiModelProperty(value = "已入库数量")
    private Integer storagedCount;

//    @Valid
//    @NotEmpty(message = "deviceLibrarySaveVoList不能为空")
    @ApiModelProperty(value = "入库各装备详情")
    private List<DeviceLibrarySaveVo> deviceLibrarySaveVoList = new ArrayList<>();

    @ApiModelProperty(value = "入库列装详情")
    private List<StorageBillDetail> storageBillDetails = new ArrayList<>();

    @ApiModelProperty(value = "存在申请任务的序列号")
    private List<String> hasTaskSeqs = new ArrayList<>();

    @ApiModelProperty(value = "装备存放位置",notes = "默认是库房")
    private String storageLocation ;



    public StorageBill toDo() {
        //modelMap复制
        ModelMapper mapper = BeanHelper.getUserMapper();
        StorageBill storageBillEntity = mapper.map(this, StorageBill.class);
        storageBillEntity.setStorageStatus(2);
        storageBillEntity.setStorageDetail("x");
        storageBillEntity.setPackingDetail(JacksonUtil.toJSon(storageBillDetails));
        if(this.replyFiles!=null&&this.replyFiles.size()>0){
            storageBillEntity.setReplyFiles(FilesUtil.stringFileToList(this.replyFiles));
        }
        if(this.applyFiles!=null&&this.applyFiles.size()>0){
            storageBillEntity.setApplyFiles(FilesUtil.stringFileToList(this.applyFiles));
        }
        if(this.allotFiles!=null&&this.allotFiles.size()>0){
            storageBillEntity.setAllotFiles(FilesUtil.stringFileToList(this.allotFiles));
        }
        return storageBillEntity;
    }
}
