package com.tykj.dev.device.task.subject.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("任务置顶类")
public class TaskTopVo {

    @NotNull(message = "taskId不能为空")
    @Min(value = 1,message = "taskId不能小于1")
    @ApiModelProperty(value = "任务Id")
    private Integer taskId;

    @NotNull(message = "topFlag不能为空")
    @Min(value = 0,message = "topFlag不能小于0")
    @ApiModelProperty(name = "置顶标志", example = "0", value = "0为不置顶,1为置顶")
    private Integer topFlag;
}
