package com.tykj.dev.device.taskselect.controller;

import com.fasterxml.jackson.core.type.TypeReference;
import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.allot.service.AllotBackBillService;
import com.tykj.dev.device.allot.service.AllotBillService;
import com.tykj.dev.device.allot.subject.domin.AllotBackBill;
import com.tykj.dev.device.allot.subject.domin.AllotBill;
import com.tykj.dev.device.apply.service.DeviceApplyBillService;
import com.tykj.dev.device.apply.subject.domin.DeviceApplyBill;
import com.tykj.dev.device.apply.subject.vo.ApplyBillDetailVo;
import com.tykj.dev.device.apply.subject.vo.ReplyVo;
import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.file.service.FilesUtil;
import com.tykj.dev.device.library.repository.DeviceLibraryDao;
import com.tykj.dev.device.library.service.DeviceLibraryService;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.library.subject.vo.DeviceLibrarySelectVo;
import com.tykj.dev.device.library.subject.vo.ScriptSaveVo;
import com.tykj.dev.device.matching.service.MatchingDeviceBillService;
import com.tykj.dev.device.matching.service.MatchingDeviceLibraryService;
import com.tykj.dev.device.matching.subject.domin.MatchingDeviceBill;
import com.tykj.dev.device.matching.subject.domin.MatchingDeviceLibrary;
import com.tykj.dev.device.packing.service.PackingLibraryService;
import com.tykj.dev.device.packing.subject.domin.PackingLibrary;
import com.tykj.dev.device.repair.service.RepairBackBillService;
import com.tykj.dev.device.repair.service.RepairBillService;
import com.tykj.dev.device.repair.subject.domin.RepairBackBill;
import com.tykj.dev.device.repair.subject.domin.RepairBill;
import com.tykj.dev.device.selfcheck.service.SelfCheckBillService;
import com.tykj.dev.device.selfcheck.subject.domin.SelfCheckBill;
import com.tykj.dev.device.storage.service.StorageBillService;
import com.tykj.dev.device.storage.subject.domin.StorageBill;
import com.tykj.dev.device.task.repository.TaskDao;
import com.tykj.dev.device.task.service.TaskService;
import com.tykj.dev.device.task.subject.bto.TaskBto;
import com.tykj.dev.device.task.subject.domin.Task;
import com.tykj.dev.device.taskselect.vo.SignatureSaveVo;
import com.tykj.dev.device.user.subject.service.UserPublicService;
import com.tykj.dev.misc.base.ResultObj;
import com.tykj.dev.misc.exception.ApiException;
import com.tykj.dev.misc.utils.JacksonUtil;
import com.tykj.dev.misc.utils.ResultUtil;
import com.tykj.dev.misc.utils.Snowflake;
import com.tykj.dev.misc.utils.StringSplitUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import static java.util.stream.Collectors.toMap;

/**
 * @author dengdiyi
 */
@RestController
@Api(tags = "业务模块", description = "业务模块")
@AutoDocument
@RequestMapping("/business")
public class TaskSelectController {

    @Autowired
    private TaskService taskService;

    @Autowired
    private PackingLibraryService packingLibraryService;

    @Autowired
    private UserPublicService userPublicService;

    @Autowired
    private StorageBillService storageBillService;

    @Autowired
    private DeviceLibraryService deviceLibraryService;

    @Autowired
    private DeviceApplyBillService deviceApplyBillService;

    @Autowired
    private AllotBillService allotBillService;

    @Autowired
    private SelfCheckBillService selfCheckBillService;

    @Autowired
    private MatchingDeviceBillService matchingDeviceBillService;

    @Autowired
    private MatchingDeviceLibraryService matchingDeviceLibraryService;

    @Autowired
    private AllotBackBillService allotBackBillService;

    @Autowired
    private RepairBillService repairBillService;

    @Autowired
    private RepairBackBillService repairBackBillService;


    @Autowired
    private Snowflake snowflake;

    @Autowired
    private TaskDao taskDao;

    @Autowired
    private DeviceLibraryDao deviceLibraryDao;

    @ApiOperation(value = "查询业务对应页面的数据", notes = "可以通过这个接口查询业务对应页面的数据")
    @GetMapping("/manage/detail/{id}")
    public ResponseEntity selectData(@PathVariable("id") int taskId) {

        Map<Integer,DeviceLibrary> deviceLibraryMap = deviceLibraryService.getAllDeviceMap();
        TaskBto taskBto = taskService.get(taskId);
        Integer bussinessType = taskBto.getBusinessType();
        Integer billId = taskBto.getBillId();
        List<Object> list = new ArrayList<>();
        list.add(taskBto);
        switch (bussinessType) {
            case 1:
                PackingLibrary packingLibraryEntity = packingLibraryService.getOne(billId);
                packingLibraryEntity.setUserA(userPublicService.getOne(packingLibraryEntity.getUseraId()).getName());
                packingLibraryEntity.setUserB(userPublicService.getOne(packingLibraryEntity.getUserbId()).getName());
                list.add(packingLibraryEntity);
                List<PackingLibrary> packingLibraryEntities = packingLibraryService.selectAllPart(billId);
                list.add(packingLibraryEntities);
                return ResponseEntity.ok(new ResultObj(list, "查询成功"));
            case 2:
                StorageBill storageBillEntity = storageBillService.getOne(billId);
                storageBillEntity.setReceiveUserA(userPublicService.getOne(storageBillEntity.getReceiveUseraId()).getName());
                storageBillEntity.setReceiveUserB(userPublicService.getOne(storageBillEntity.getReceiveUserbId()).getName());
                storageBillEntity.setReplyFileList(FilesUtil.stringFileToList(storageBillEntity.getReplyFiles()));
                storageBillEntity.setApplyFileList(FilesUtil.stringFileToList(storageBillEntity.getApplyFiles()));
                storageBillEntity.setAllotFileList(FilesUtil.stringFileToList(storageBillEntity.getAllotFiles()));
                storageBillEntity.setOtherFileList(FilesUtil.stringFileToList(storageBillEntity.getOtherFiles()));
                list.add(storageBillEntity);
                String str = storageBillEntity.getStorageDetail();
                List<Integer> list1 = StringSplitUtil.userIdSplit(str);
                List<DeviceLibrary> libraryEntities = new ArrayList<>();
                for (Integer id : list1) {
                    DeviceLibrary deviceLibraryEntity = deviceLibraryMap.get(id);
                    libraryEntities.add(deviceLibraryEntity);
                }
                list.add(libraryEntities);
                return ResponseEntity.ok(new ResultObj(list, "查询成功"));
            case 3:
                if (taskBto.getBillId() == 0) {
                    TaskBto applyTask = taskService.get(taskBto.getParentTaskId());
                    DeviceApplyBill deviceApplyBillEntity = deviceApplyBillService.getOne(applyTask.getBillId());
                    List<Integer> idList = StringSplitUtil.userIdSplit(deviceApplyBillEntity.getApplyDetail());
                    List<Integer> packingIdList = new ArrayList<>();
                    List<Integer> numList = new ArrayList<>();
                    List<PackingLibrary> packingLibraryEntityList = new ArrayList<>();
                    if (idList.size() > 0) {
                        for (int i = 1; i <= idList.size(); i++) {
                            if (i % 2 == 1) {
                                packingIdList.add(idList.get(i - 1));
                            } else {
                                numList.add(idList.get(i - 1));
                            }
                        }
                    }
                    if (packingIdList.size() == numList.size()) {
                        for (int i = 0; i < packingIdList.size(); i++) {
                            PackingLibrary p = packingLibraryService.getOne(packingIdList.get(i));
                            p.setApplyNum(numList.get(i));
                            packingLibraryEntityList.add(p);
                        }
                    }
                    list.add(packingLibraryEntityList);
                    //查询可配发相同类型装备列表
                    list.add(deviceLibraryService.getAllotList(new DeviceLibrarySelectVo()).stream().filter(deviceLibraryEntity -> packingIdList.contains(deviceLibraryEntity.getPackingId())).sorted(Comparator.comparing(DeviceLibrary::getPackingId)).collect(Collectors.toList()));
                    //添加申请单
                    deviceApplyBillEntity.setReplyFileList(FilesUtil.stringFileToList(deviceApplyBillEntity.getReplyFiles()));
                    deviceApplyBillEntity.setApplyFileList(FilesUtil.stringFileToList(deviceApplyBillEntity.getApplyFiles()));
                    deviceApplyBillEntity.setApplyNumFileList(FilesUtil.stringFileToList(deviceApplyBillEntity.getApplyNumFiles()));
                    deviceApplyBillEntity.setApplyUser(userPublicService.getOne(deviceApplyBillEntity.getApplyUseraId()).getName());
                    list.add(deviceApplyBillEntity);
                    return ResponseEntity.ok(new ResultObj(list, "查询成功"));
                }

                AllotBill allotBillEntity = allotBillService.getOne(billId);
                allotBillEntity.setReplyFileList(FilesUtil.stringFileToList(allotBillEntity.getReplyFiles()));
                allotBillEntity.setApplyFileList(FilesUtil.stringFileToList(allotBillEntity.getApplyFiles()));
                allotBillEntity.setSendFileList(FilesUtil.stringFileToList(allotBillEntity.getSendFiles()));
                allotBillEntity.setReceiveFileList(FilesUtil.stringFileToList(allotBillEntity.getReceiveFiles()));
                if (allotBillEntity.getSendUseraId() != null) {
                    allotBillEntity.setSenderUserA(userPublicService.getOne(allotBillEntity.getSendUseraId()).getName());
                }
//                if (allotBillEntity.getSendUserbId() != null) {
//                    allotBillEntity.setSenderUserB(userPublicService.getOne(allotBillEntity.getSendUserbId()).getName());
//                }
                allotBillEntity.setSenderUserB(allotBillEntity.getAgent());
                if (allotBillEntity.getReceiveUseraId() != null) {
                    allotBillEntity.setReceiveUserA(userPublicService.getOne(allotBillEntity.getReceiveUseraId()).getName());
                }
                if (allotBillEntity.getReceiveUserbId() != null) {
                    allotBillEntity.setReceiveUserB(userPublicService.getOne(allotBillEntity.getReceiveUserbId()).getName());
                }
                if (allotBillEntity.getScriptJson()!=null){
                    allotBillEntity.setScripts(JacksonUtil.readValue(allotBillEntity.getScriptJson(),new TypeReference<List<ScriptSaveVo>>() {}));
                }
                list.add(allotBillEntity);
                String str2 = allotBillEntity.getAllotCheckDetail();
                List<DeviceLibrary> deviceLibraryEntities = new ArrayList<>();
                if (str2 != null) {
                    String[] strings1 = str2.split("x");
                    for (String s : strings1) {
                        if (s.length() >= 2 && "1".equals(s.substring(s.length() - 1))) {
                            Integer id = Integer.parseInt(s.substring(0, s.length() - 1));
                            Integer checkResult = Integer.parseInt(s.substring(s.length() - 1));
                            DeviceLibrary deviceLibraryEntity = deviceLibraryMap.get(id);
                            deviceLibraryEntity.setCheckResult(checkResult);
                            deviceLibraryEntities.add(deviceLibraryEntity);
                        }
                    }
                }
                list.add(deviceLibraryEntities);
                return ResponseEntity.ok(new ResultObj(list, "查询成功"));
            case 22:
                if (taskBto.getBillId() == 0) {
                    TaskBto allotTask = taskService.get(taskBto.getParentTaskId());
                    AllotBill allotBill = allotBillService.getOne(allotTask.getBillId());
                    list.add(allotBill);
                    String checkDetail = allotBill.getAllotCheckDetail();
                    List<DeviceLibrary> deviceLibraries = new ArrayList<>();
                    if (checkDetail != null) {
                        String[] strings1 = checkDetail.split("x");
                        for (String s : strings1) {
                            if (s.length() >= 2 && "1".equals(s.substring(s.length() - 1))) {
                                Integer id = Integer.parseInt(s.substring(0, s.length() - 1));
                                Integer checkResult = Integer.parseInt(s.substring(s.length() - 1));
                                DeviceLibrary deviceLibraryEntity = deviceLibraryMap.get(id);
                                deviceLibraryEntity.setCheckResult(checkResult);
                                deviceLibraries.add(deviceLibraryEntity);
                            }
                        }
                    }
                    list.add(deviceLibraries);
                    return ResponseEntity.ok(new ResultObj(list, "查询成功"));
                }
                AllotBackBill allotBackBill = allotBackBillService.getOne(billId);
                if (allotBackBill.getSendUseraId() != null) {
                    allotBackBill.setSenderUserA(userPublicService.getOne(allotBackBill.getSendUseraId()).getName());
                }
                allotBackBill.setSenderUserB(allotBackBill.getAgent());
                if (allotBackBill.getReceiveUseraId() != null) {
                    allotBackBill.setReceiveUserA(userPublicService.getOne(allotBackBill.getReceiveUseraId()).getName());
                }
                if (allotBackBill.getReceiveUserbId() != null) {
                    allotBackBill.setReceiveUserB(userPublicService.getOne(allotBackBill.getReceiveUserbId()).getName());
                }
                allotBackBill.setSendFileList(FilesUtil.stringFileToList(allotBackBill.getSendFiles()));
                allotBackBill.setReceiveFileList(FilesUtil.stringFileToList(allotBackBill.getReceiveFiles()));
                allotBackBill.setReplyFileList(FilesUtil.stringFileToList(allotBackBill.getReplyFiles()));
                allotBackBill.setApplyFileList(FilesUtil.stringFileToList(allotBackBill.getApplyFiles()));
                if (allotBackBill.getScriptJson()!=null){
                    allotBackBill.setScripts(JacksonUtil.readValue(allotBackBill.getScriptJson(),new TypeReference<List<ScriptSaveVo>>() {}));
                }
                list.add(allotBackBill);
                String detail = allotBackBill.getBackCheckDetail();
                List<DeviceLibrary> libraryArrayList = new ArrayList<>();
                if (detail != null) {
                    String[] strings1 = detail.split("x");
                    for (String s : strings1) {
                        if (s.length() >= 2 && "1".equals(s.substring(s.length() - 1))) {
                            Integer id = Integer.parseInt(s.substring(0, s.length() - 1));
                            Integer checkResult = Integer.parseInt(s.substring(s.length() - 1));
                            DeviceLibrary deviceLibraryEntity = deviceLibraryMap.get(id);
                            deviceLibraryEntity.setCheckResult(checkResult);
                            libraryArrayList.add(deviceLibraryEntity);
                        }
                    }
                }
                list.add(libraryArrayList);
                return ResponseEntity.ok(new ResultObj(list, "查询成功"));
            case 4:
                SelfCheckBill selfExaminationBillEntity = selfCheckBillService.getOne(billId);
                if (selfExaminationBillEntity.getUseraId() != null) {
                    selfExaminationBillEntity.setCheckUser(userPublicService.getOne(selfExaminationBillEntity.getUseraId()).getName());
                }
                if (selfExaminationBillEntity.getUserbId() != null) {
                    selfExaminationBillEntity.setConfirmUser(userPublicService.getOne(selfExaminationBillEntity.getUserbId()).getName());
                }
                selfExaminationBillEntity.setCheckFileList(FilesUtil.stringFileToList(selfExaminationBillEntity.getCheckFiles()));
                list.add(selfExaminationBillEntity);
                String str3 = selfExaminationBillEntity.getCheckDetail();
                String str4 = selfExaminationBillEntity.getNewDeviceDetail();
                String[] split;
                if (str3!=null) {
                    split = str3.split("x");
                }
                else {
                    split = new String[0];
                }
                if (str4 != null) {
                    String[] split2 = str4.split("\\.");
                    List<DeviceLibrary> newDeviceList = new ArrayList<>();
                    for (String rfid : split2) {
                        if (rfid.length() > 0) {
                            DeviceLibrary d = new DeviceLibrary();
                            d.setCheckResult(2);
                            d.setSeqNumber("-");
                            d.setName("-");
                            d.setType(0);
                            d.setRfidSurfaceId("-");
                            d.setProdNumber("-");
                            d.setRfidCardId(rfid);
                            newDeviceList.add(d);
                        }
                    }
                    list.add(newDeviceList);
                }
                if (str4 == null) {
                    List<DeviceLibrary> newDeviceList = new ArrayList<>();
                    list.add(newDeviceList);
                }
                List<DeviceLibrary> libraryEntities1 = new ArrayList<>();
                for (String s : split) {
                    if (s.length() >= 2) {
                        Integer id = Integer.parseInt(s.substring(0, s.length() - 1));
                        Integer checkResult = Integer.parseInt(s.substring(s.length() - 1));
                        DeviceLibrary deviceLibraryEntity = deviceLibraryMap.get(id);
                        deviceLibraryEntity.setCheckResult(checkResult);
                        libraryEntities1.add(deviceLibraryEntity);
                    }
                }
                list.add(libraryEntities1);
                if (selfExaminationBillEntity.getUnStockDetail()!=null){
                    list.add(JacksonUtil.readValue(selfExaminationBillEntity.getUnStockDetail(), new TypeReference<List<DeviceLibrary>>() {
                    }));
                }
                return ResponseEntity.ok(new ResultObj(list, "查询成功"));
            case 19:
                MatchingDeviceBill matchingDeviceBillEntity = matchingDeviceBillService.getOne(billId);
                list.add(matchingDeviceBillEntity);
                List<Integer> integerList = StringSplitUtil.userIdSplit(matchingDeviceBillEntity.getDeviceDetail());
                List<MatchingDeviceLibrary> matchingDeviceLibraryEntities = new ArrayList<>();
                if (integerList.size() > 0) {
                    for (Integer id : integerList) {
                        if (id > 0) {
                            matchingDeviceLibraryEntities.add(matchingDeviceLibraryService.getOne(id));
                        }
                    }
                }
                list.add(matchingDeviceLibraryEntities);
                return ResponseEntity.ok(new ResultObj(list, "查询成功"));
            case 9:
                DeviceApplyBill deviceApplyBillEntity = deviceApplyBillService.getOne(taskBto.getBillId());
                deviceApplyBillEntity.setApplyUser(userPublicService.getOne(deviceApplyBillEntity.getApplyUseraId()).getName());
                deviceApplyBillEntity.setReplyFileList(FilesUtil.stringFileToList(deviceApplyBillEntity.getReplyFiles()));
                deviceApplyBillEntity.setApplyFileList(FilesUtil.stringFileToList(deviceApplyBillEntity.getApplyFiles()));
                deviceApplyBillEntity.setBackFileList(FilesUtil.stringFileToList(deviceApplyBillEntity.getBackFiles()));
                deviceApplyBillEntity.setApplyNumFileList(FilesUtil.stringFileToList(deviceApplyBillEntity.getApplyNumFiles()));
                List<ApplyBillDetailVo> applyBillDetailVos = JacksonUtil.readValue(deviceApplyBillEntity.getApplyStat(), new TypeReference<List<ApplyBillDetailVo>>() {
                });
                Map<Integer, ApplyBillDetailVo> applyBillDetailVoMap = applyBillDetailVos.stream().collect(toMap(ApplyBillDetailVo::getPackingId, Function.identity()));
                Map<Integer,ReplyVo> map = new HashMap<>();
                if (deviceApplyBillEntity.getReplyVos()!=null) {
                    map = Objects.requireNonNull(JacksonUtil.readValue(deviceApplyBillEntity.getReplyVos(), new TypeReference<List<ReplyVo>>() {
                    })).stream().collect(toMap(ReplyVo::getId, Function.identity()));
                }
                Map<Integer,ApplyBillDetailVo> statMap = new HashMap<>();
                if (deviceApplyBillEntity.getApplyStat()!=null){
                    statMap = Objects.requireNonNull(JacksonUtil.readValue(deviceApplyBillEntity.getApplyStat(), new TypeReference<List<ApplyBillDetailVo>>() {
                    })).stream().collect(toMap(ApplyBillDetailVo::getPackingId, Function.identity()));
                }
                list.add(deviceApplyBillEntity);
                List<Integer> idList = StringSplitUtil.userIdSplit(deviceApplyBillEntity.getApplyDetail());
                List<Integer> packingIdList = new ArrayList<>();
                List<Integer> numList = new ArrayList<>();
                List<PackingLibrary> packingLibraryEntityList = new ArrayList<>();
                if (idList.size() > 0) {
                    for (int i = 1; i <= idList.size(); i++) {
                        if (i % 2 == 1) {
                            packingIdList.add(idList.get(i - 1));
                        } else {
                            numList.add(idList.get(i - 1));
                        }
                    }
                }
                if (packingIdList.size() == numList.size()) {
                    for (int i = 0; i < packingIdList.size(); i++) {
                        PackingLibrary p = packingLibraryService.getOne(packingIdList.get(i));
                        ApplyBillDetailVo applyBillDetailVo = applyBillDetailVoMap.get(packingIdList.get(i));
                        if (deviceApplyBillEntity.getApplyType()==1) {
                            p.setApplyNum(numList.get(i));
                            if (statMap.size()>0){
                                p.setCompleteNum(statMap.get(p.getId()).getCompleteCount());
//                                p.setWaitNum(p.getApplyNum()-p.getCompleteNum());
                                if(applyBillDetailVo.getWaitNum() == null){
                                    p.setWaitNum(null);
                                }else {
                                    p.setWaitNum(applyBillDetailVo.getWaitNum()-p.getCompleteNum());
                                }
//                                p.setWaitNum(applyBillDetailVo.getWaitNum()-p.getCompleteNum());
                                p.setSeq(statMap.get(p.getId()).getSeqInterval());
                            }
                        }
                        else {
                            if (map.size()>0) {
                                p.setApplyNum(map.get(p.getId()).getNum());
                                p.setSeq(map.get(p.getId()).getSeqInterval());
                                p.setCompleteNum(map.get(p.getId()).getCompleteCount());
                                if(applyBillDetailVo.getWaitNum() == null){
                                    p.setWaitNum(null);
                                }else {
                                    p.setWaitNum(applyBillDetailVo.getWaitNum()-p.getCompleteNum());
                                }
//                                p.setWaitNum(p.getApplyNum()-p.getCompleteNum());
//                                p.setWaitNum(applyBillDetailVo.getWaitNum()-p.getCompleteNum());
//                                p.setWaitNum(p.getWaitNum()-p.getCompleteNum());
                            }
                        }
                        packingLibraryEntityList.add(p);
                    }
                }
                list.add(packingLibraryEntityList);
                list.add(deviceLibraryService.getAllotList(new DeviceLibrarySelectVo()).stream().filter(deviceLibraryEntity -> packingIdList.contains(deviceLibraryEntity.getPackingId())).sorted(Comparator.comparing(DeviceLibrary::getPackingId)).collect(Collectors.toList()));
                List<Task> tasks = taskDao.findAllByParentTaskId(taskId);
                List<DeviceLibrary> deviceLibraries = new ArrayList<>();
                if (tasks.size() == 1) {
                    Task task = tasks.get(0);
                    if (task.getBusinessType() == 3) {
                        if (task.getBillId() > 0) {
                            AllotBill allotBill = allotBillService.getOne(task.getBillId());
                            if (allotBill.getAllotCheckDetail() != null) {
                                StringSplitUtil.split(allotBill.getAllotCheckDetail()).forEach(integer -> {
                                    deviceLibraries.add(deviceLibraryMap.get(integer));
                                });
                            }
                        }
                    }
                }
                list.add(deviceLibraries);
                return ResponseEntity.ok(new ResultObj(list, "查询成功"));
            default:
                throw new ApiException(ResultUtil.failed("该接口不支持当前task业务类型"));
        }
    }

    @ApiOperation(value = "业务账单添加电子签章", notes = "可以通过这个接口业务账单添加电子签章")
    @GetMapping("/signature/form")
    public ResponseEntity addSignature(@RequestBody SignatureSaveVo signatureSaveVo) {
        //找到对应task
        TaskBto taskBto = taskService.get(signatureSaveVo.getTaskId());
        //判断task类型
        Integer businessType = taskBto.getBusinessType();
        switch (businessType) {
            case 3:
                if (taskBto.getBillId() > 0) {
                    AllotBill allotBill = allotBillService.getOne(taskBto.getBillId());
                    if (signatureSaveVo.getType() == 1) {
                        allotBill.setLeftSignatureId(signatureSaveVo.getSignatureId());
                    }
                    if (signatureSaveVo.getType() == 2) {
                        allotBill.setRightSignatureId(signatureSaveVo.getSignatureId());
                    }
                    allotBillService.update(allotBill);
                    return ResponseEntity.ok("添加成功");
                } else {
                    throw new ApiException(ResultUtil.failed("当前task不存在账单id"));
                }
            case 22:
                if (taskBto.getBillId() > 0) {
                    AllotBackBill allotBackBill = allotBackBillService.getOne(taskBto.getBillId());
                    if (signatureSaveVo.getType() == 1) {
                        allotBackBill.setLeftSignatureId(signatureSaveVo.getSignatureId());
                    }
                    if (signatureSaveVo.getType() == 2) {
                        allotBackBill.setRightSignatureId(signatureSaveVo.getSignatureId());
                    }
                    allotBackBillService.update(allotBackBill);
                    return ResponseEntity.ok("添加成功");
                } else {
                    throw new ApiException(ResultUtil.failed("当前task不存在账单id"));
                }
            case 5:
                if (taskBto.getBillId() > 0) {
                    RepairBill repairBill = repairBillService.getOne(taskBto.getBillId());
                    if (signatureSaveVo.getType() == 1) {
                        repairBill.setLeftSignatureId(signatureSaveVo.getSignatureId());
                    }
                    if (signatureSaveVo.getType() == 2) {
                        repairBill.setRightSignatureId(signatureSaveVo.getSignatureId());
                    }
                    repairBillService.update(repairBill);
                    return ResponseEntity.ok("添加成功");
                } else {
                    throw new ApiException(ResultUtil.failed("当前task不存在账单id"));
                }
            case 10:
                if (taskBto.getBillId() > 0) {
                    RepairBackBill repairBackBill = repairBackBillService.getOne(taskBto.getBillId());
                    if (signatureSaveVo.getType() == 1) {
                        repairBackBill.setLeftSignatureId(signatureSaveVo.getSignatureId());
                    }
                    if (signatureSaveVo.getType() == 2) {
                        repairBackBill.setRightSignatureId(signatureSaveVo.getSignatureId());
                    }
                    repairBackBillService.update(repairBackBill);
                    return ResponseEntity.ok("添加成功");
                } else {
                    throw new ApiException(ResultUtil.failed("当前task不存在账单id"));
                }
            case 16:
                if (taskBto.getBillId() > 0) {
                    return ResponseEntity.ok("添加成功");
                } else {
                    throw new ApiException(ResultUtil.failed("当前task不存在账单id"));
                }
            default:
                throw new ApiException(ResultUtil.failed("该接口不支持当前task业务类型"));
        }
    }

    @ApiOperation(value = "生成电子签章随机id", notes = "可以通过这个接口生成电子签章随机id")
    @GetMapping("/signature/create")
    public ResponseEntity createSignatureId() {
        return ResponseEntity.ok(snowflake.creatNextId());
    }
}
