package com.tykj.dev.device.train.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.train.entity.GenerateTestPaper;
import com.tykj.dev.device.train.entity.TrainTheme;
import com.tykj.dev.device.train.service.TestPaperService;
import com.tykj.dev.device.train.service.TrainThemeService;
import com.tykj.dev.device.user.subject.entity.SecurityUser;
import com.tykj.dev.misc.utils.JacksonUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName TestPaperController.java
 * @Description TODO
 * @createTime 2021年05月30日 16:53:00
 */
@RestController
@RequestMapping(value = "/testPaper")
@AutoDocument
@Api(tags = "试卷模块", description = "试卷模块")
public class TestPaperController {
    @Autowired
    TestPaperService testPaperService;

    @Autowired
    TrainThemeService trainThemeService;
    /**
     * 生成试卷
     */
    @PostMapping("/generateTestPaper")
    public ResponseEntity trainThemeVoResponseEntity(@RequestBody GenerateTestPaper generateTestPaper) {

        return ResponseEntity.ok(testPaperService.generateTestPaper(generateTestPaper));
    }

    /**
     * 查询试卷
     */
    @GetMapping("/select/{status}")
    @ApiOperation(value = "查询试卷(status 为0 待批阅 1 为已批阅)", notes = "查询试卷")
    public ResponseEntity trainThemeVoResponseEntity(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser,@PathVariable Integer status) {

        return ResponseEntity.ok(testPaperService.TEST_PAPER_MANAGEMENT_LIST_VOS(securityUser.getCurrentUserInfo().getUnitsId(),status));
    }

    /**
     * 批阅试卷上边框集合接口
     */
    @GetMapping("/testPaperListVo/{trainId}")
    @ApiOperation(value = "批阅试卷上边框集合接口", notes = "批阅试卷上边框集合接口")
    public ResponseEntity trainThemeVoResponseEntity(@PathVariable Integer trainId) {

        return ResponseEntity.ok(testPaperService.findAllByTrainId(trainId));
    }

    /**
     * 根据试卷id查询试卷详情
     */
    @GetMapping("/testPaper/{id}")
    @ApiOperation(value = "根据试卷id查询试卷详情", notes = "根据试卷id查询试卷详情")
    public ResponseEntity testPaperById(@PathVariable Integer id) {

        return ResponseEntity.ok(testPaperService.findByIdProble(id));
    }


    /**
     * 根据id查询试卷的模版
     */
    @GetMapping("/generateTestPaper/{trainId}")
    @ApiOperation(value = "根据id查询试卷的模版", notes = "根据id查询试卷的模版")
    public ResponseEntity generateTestPaperById(@PathVariable Integer trainId) {
        TrainTheme trainTheme=trainThemeService.findById(trainId);
        trainTheme.setGenerateTestPaper(JacksonUtil.readValue(trainTheme.getGenerateTestPaperString(),GenerateTestPaper.class));
        return ResponseEntity.ok(trainTheme);
    }


}
