package com.tykj.dev.device.train.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.excel.utils.ExcelStyleUtil;
import com.tykj.dev.device.train.entity.TrainTheme;
import com.tykj.dev.device.train.entity.TrainUser;
import com.tykj.dev.device.train.entity.vo.ConditionsTrainVo;
import com.tykj.dev.device.train.entity.vo.TrainUserExcelVo;
import com.tykj.dev.device.train.service.TrainThemeService;
import com.tykj.dev.device.user.subject.dao.UnitsDao;
import com.tykj.dev.device.user.subject.entity.SecurityUser;
import com.tykj.dev.device.user.subject.service.MgrcertService;
import com.tykj.dev.device.user.subject.service.UnitsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName TrainController.java
 * @Description TODO
 * @createTime 2020年08月11日 21:42:00
 */
@RestController
@RequestMapping(value = "/user/train")
@AutoDocument
@Api(tags = "专管员培训", description = "培训接口")
public class TrainController {


    @Autowired
    TrainThemeService trainThemeService;
    //    @Autowired
//    JobService jobService;
    @Autowired
    MgrcertService mgrcertService;


    @Autowired
    UnitsDao unitsDao;

    @Autowired
    UnitsService unitsService;

    /**
     * 培训列表查询接口（分页）
     *
     * @return
     */
    @PostMapping("/summary/page")
    public ResponseEntity trainThemeVoResponseEntity(@RequestBody ConditionsTrainVo conditionsTrainVo) {

        return ResponseEntity.ok(trainThemeService.findTrainPageVo(conditionsTrainVo));
    }

    /**
     * 培训详情接口
     *
     * @param trainThemeId 培训id
     */
    @GetMapping("/detail/{trainThemeId}")
    public ResponseEntity trainThemeVoResponseEntity(@PathVariable Integer trainThemeId) {

        return ResponseEntity.ok(trainThemeService.findById(trainThemeId));
    }

    /**
     * 根据taskId查询培训信息
     */
    @GetMapping("/detail/task/{taskId}")
    public ResponseEntity trainThemeVoResponseEntity1(@PathVariable Integer taskId) {

        return ResponseEntity.ok(trainThemeService.findBytaskId(taskId));
    }

    /**
     * 查询培训的单位组织结构 省以下,不包括直属单位
     */
    @GetMapping("/unit")
    @ApiOperation(value = "省培训发证审核以及市培训申请发证审核调用接口", notes = "同意培训完成")
    public ResponseEntity selectTrainUnitsOrganization(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser){
        return ResponseEntity.ok(unitsService.findLeftNavigationNotDirectlyUnit(securityUser));
    }

    @GetMapping("/export/trainUser/{trainId}")
    @ApiOperation(value = "导出培训人员信息", notes = "导出培训人员信息")
    public ResponseEntity selectTrainUnitsOrganization(@PathVariable Integer trainId, HttpServletRequest request, HttpServletResponse response){
        TrainTheme trainTheme= trainThemeService.findById(trainId);
        List<TrainUserExcelVo> trainUsers=trainThemeService.findAllTrainUserByTrainId(trainId).stream().map(TrainUser::toTrainUserExcelVo).collect(Collectors.toList());
        ExportParams exportParams = new ExportParams(trainTheme.getName()+"参加人员名单",trainTheme.getName()+"参加人员名单", ExcelType.XSSF);
        exportParams.setStyle(ExcelStyleUtil.class);
        Workbook workbook = ExcelExportUtil.exportExcel(exportParams, TrainUserExcelVo.class, trainUsers);
        com.tykj.dev.device.excel.utils.ExcelUtil.downloadExcel(request, response, workbook, trainTheme.getName()+"参加人员名单");
        return ResponseEntity.ok("ok");
    }

}
