package com.tykj.dev.device.train.entity;

import com.tykj.dev.device.train.entity.vo.ProblemVo;
import com.tykj.dev.device.train.entity.vo.TestPaperListVo;
import com.tykj.dev.misc.base.BaseEntity;
import com.tykj.dev.misc.base.BeanHelper;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Transient;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName TestPaper.java
 * @Description 试卷对象
 * @createTime 2021年05月30日 14:03:00
 */
@ApiModel("试卷对象")
@AllArgsConstructor
@NoArgsConstructor
@EntityListeners(AuditingEntityListener.class)
@Data
@Entity
public class TestPaper extends BaseEntity {

      /**
     * 阅卷人
     */
    @ApiModelProperty(value = "阅卷人（不）", example = "bmxx", name = "taskId")
    private String markingName;

    /**
     * 总分
     */
    @ApiModelProperty(value = "总分（不）", example = "bmxx", name = "taskId")
    private Float countScore;

//    /**
//     * 总分得分
//     */
//    @ApiModelProperty(value = "总分（不）", example = "bmxx", name = "taskId")
//    private Float countUserScore;

    /**
     * 试卷所属用户id
     */
    @ApiModelProperty(value = "用户id", example = "bmxx", name = "taskId")
    private Integer userId;

    /**
     * 试卷所属用户名称
     */
    @ApiModelProperty(value = "用户名称", example = "bmxx", name = "taskId")
    private String userName;

    @ApiModelProperty(value = "培训id", example = "bmxx", name = "taskId")
    private Integer trainId;

    @ApiModelProperty(value = "任务id", example = "bmxx", name = "taskId")
    private Integer taskId;

    //选择题
    @Column(name = "choose_problem",columnDefinition = "TEXT")
    @ApiModelProperty(value = "选择题（不）", example = "bmxx", name = "taskId")
    private String chooseProblem;

    //判断
    @Column(name = "judge_problem",columnDefinition = "TEXT")
    @ApiModelProperty(value = "判断（不）", example = "bmxx", name = "taskId")
    private String judgeProblem;

    //多选
    @Column(name = "multiple_choiceProblem",columnDefinition = "TEXT")
    @ApiModelProperty(value = "多选（不）", example = "bmxx", name = "taskId")
    private String multipleChoiceProblem;

    //简答
    @Column(name = "short_answer_problem",columnDefinition = "TEXT")
    @ApiModelProperty(value = "简答db（不）", example = "bmxx", name = "taskId")
    private String shortAnswerProblem;

    @ApiModelProperty(value = "选择题所得的分数(不)", example = "bmxx", name = "chooseScore")
    private Float chooseScore;

    @ApiModelProperty(value = "判断所得的分数(不)", example = "bmxx", name = "chooseScore")
    private Float judgeScore;

    @ApiModelProperty(value = "多选所得的分数(不)", example = "bmxx", name = "chooseScore")
    private Float multipleScore;

    @ApiModelProperty(value = "简答所得的分数(不)", example = "bmxx", name = "chooseScore")
    private Float shortAnswerScore;

    @Transient
    @ApiModelProperty(value = "选择题集合", example = "bmxx", name = "chooseScore")
    private List<ProblemVo> chooseProblemList;

    @Transient
    @ApiModelProperty(value = "判断集合", example = "bmxx", name = "chooseScore")
    private List<ProblemVo> judgeProblemList;

    @Transient
    @ApiModelProperty(value = "多选题", example = "bmxx", name = "chooseScore")
    private List<ProblemVo> multipleChoiceProblemList;

    @Transient
    @ApiModelProperty(value = "简答题", example = "bmxx", name = "chooseScore")
    private List<ProblemVo> shortAnswerProblemList;

    /**
     * 0。待批阅 1。批阅完成
     */
    private Integer status = 0;

    @Transient
    @ApiModelProperty(value = "试卷模版", example = "bmxx", name = "chooseScore")
    private GenerateTestPaper generateTestPaper;


    public TestPaperListVo toTestPaperListVo() {
        ModelMapper mapper = BeanHelper.getUserMapper();
        return mapper.map(this, TestPaperListVo.class);
    }

}
