package com.tykj.dev.device.train.entity.vo;

import com.tykj.dev.device.file.entity.FileRet;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName GradeEntryVo.java
 * @Description 成绩录入vo类
 * @createTime 2020年08月15日 16:27:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@ApiModel(value = "录入成绩对象提交", description = "录入成绩对象")
public class GradeEntryVo {
    @ApiModelProperty(value = "成绩对象集合", name = "gradeEntryList")
    List<GradeEntry> gradeEntryList;
    @ApiModelProperty(value = "业务id", name = "trainThemeId")
    private Integer trainThemeId;
    @ApiModelProperty(value = "审核id", name = "auditId")
    private Integer auditId;

    /**
     * 0 发证 1 不发证
     */
    @ApiModelProperty(value = "0 发证 1 不发证", name = "isCertificate")
    private Integer isCertificate;

    /**
     * 是否通过
     * 0 是通过 1 是不通过
     */
    @ApiModelProperty(value = "是否通过 0 是通过 1 是不通过", name = "through")
    private Integer through;

    /**
     * 及格
     */
    @ApiModelProperty(value = "发证状态")
    private Integer pass;

    /**
     * 优秀
     */
    @ApiModelProperty(value = "发证状态")
    private Integer good;

    @ApiModelProperty(value = "培训试卷文件实体集合")
    private List<FileRet> trainPapersFileList = new ArrayList<>();

    @ApiModelProperty(value = "培训资料集合")
    private List<FileRet> trainDataFileList;
}
