package com.tykj.dev.device.train.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.train.entity.GenerateTestPaper;
import com.tykj.dev.device.train.entity.TrainUser;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Transient;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName InTrainVo.java
 * @Description 报名中
 * @createTime 2020年08月17日 23:45:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "培训中返回的对象", description = "培训中返回的对象")
public class TrainDetailsVo {
    /**
     * 培训id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty(value = "培训id")
    private Integer trainId;

    /**
     * 培训主题
     */
    @ApiModelProperty(value = "培训主题")
    private String name;

    /**
     * 报名截止时间
     */
    @ApiModelProperty(value = "报名截止时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date trainTime;

    /**
     * 发起人 originator
     */
    @ApiModelProperty(value = "发起人")
    private String originatorName;

    /**
     * 发起人 originator
     */
    @ApiModelProperty(value = "发起人id")
    private Integer originatorId;

    /**
     * 主办单位
     */
    @ApiModelProperty(value = "主办单位名称")
    private String unitsName;

    /**
     * 主办单位
     */
    @ApiModelProperty(value = "主办单位")
    private Integer unitsId;

    /**
     * 培训开始时间
     */
    @ApiModelProperty(value = "培训开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startTime;
    /**
     * 培训结束时间
     */
    @ApiModelProperty(value = "培训结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endTime;

    /**
     * 培训地点
     */
    @ApiModelProperty(value = "培训地点")
    private String trainLocation;

    /**
     * 主讲人
     */
    @ApiModelProperty(value = "主讲人")
    private String speakerUserId;

    /**
     * 培训简介
     */
    @ApiModelProperty(value = "trainSynopsis")
    private String trainSynopsis;


    /**
     * 培训资料名称
     */
    @ApiModelProperty(value = "培训资料")
    private String trainDataName;

    @ApiModelProperty(value = "培训资料集合")
    private List<FileRet> trainDataFileList;

    /**
     * 及格
     */
    @ApiModelProperty(value = "发证状态")
    private Integer pass;

    /**
     * 优秀
     */
    @ApiModelProperty(value = "发证状态")
    private Integer good;

    /**
     *
     */
    @ApiModelProperty(value = "培训试卷文件实体集合")
    @Transient
    private List<FileRet> trainPapersFileList = new ArrayList<>();

    /**
     * 成绩
     */
    @ApiModelProperty(value = "trainUsers")
    private List<TrainUser> trainUsers;


    /**
     * 培训类别
     */
    @ApiModelProperty(value = "培训类别", name = "trainType")
    private Integer trainType;

    /**
     * 考试时间限制
     */
    @ApiModelProperty(value = "考试时间限制")
    private Integer examinationTL;
//
//
    @ApiModelProperty(value = "课件集合")
    private List<CoursewareFile> coursewareFileList;

    @Transient
    private GenerateTestPaper generateTestPaper;

}
