package com.tykj.dev.device.train.entity.vo;

import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.task.subject.vo.TaskUserVo;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName WorkHandover.java
 * @Description 查询工作交接详情vo
 * @createTime 2020年09月17日 13:14:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class WorkHandoverVo {
    /**
     * 工作交接id
     */
    private Integer workHandoverId;

    /**
     * 交接人
     */
    private Integer handoverUserId;

    /**
     * 移交人
     */
    private Integer turnOverUserId;

    /**
     * 监交人
     */
    private String inUserName;
    /**
     * 代办业务 json
     */
    private List<TaskUserVo> commissionWord;

    /**
     * 跟踪业务 json
     */
    private List<TaskUserVo> trackingWord;

    /**
     * 文件集合(装备列表签字文件集合)
     */
    private List<FileRet> fileLists;
}
