package com.tykj.dev.device.train.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.tykj.dev.device.train.dao.OnlineTainUserTimeDao;
import com.tykj.dev.device.train.entity.OnlineTainUserTime;
import com.tykj.dev.device.train.entity.vo.SubjectVo;
import com.tykj.dev.device.train.service.OnlineTainUserTimeService;
import com.tykj.dev.misc.utils.JacksonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName OnlineTainUserTimeServiceImpl.java
 * @Description TODO
 * @createTime 2021年06月07日 20:09:00
 */
@Service
public class OnlineTainUserTimeServiceImpl implements OnlineTainUserTimeService {
    @Autowired
    OnlineTainUserTimeDao onlineTainUserTimeDao;

    @Override
    public OnlineTainUserTime findByUserIdAndTrainId(Integer userId, Integer trainId) {
        Optional<OnlineTainUserTime> optionalOnlineTainUserTime= onlineTainUserTimeDao.findByUserIdAndTrainId(userId,trainId);
        if (optionalOnlineTainUserTime.isPresent()) {
                OnlineTainUserTime onlineTainUserTime=optionalOnlineTainUserTime.get();
            if (onlineTainUserTime.getSubjectVoList() != null) {
                onlineTainUserTime.setSubjectVoList(JacksonUtil.readValue(onlineTainUserTime.getSubjectVos(), new TypeReference<List<SubjectVo>>() {
                }));
            }
            return onlineTainUserTime;
        }else {
            return null;
        }
    }
}
