package com.tykj.dev.device.user.base.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName DropDownUserLocation.java
 * @Description
   下拉位置更换参数对象
   选中用户 更改用户的顺序 提供下一次默认选中。
 * @createTime 2021年03月01日 11:27:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@ApiModel(value = "下拉列表选中对象位置替换参数对象", description = "下拉列表选中对象位置替换参数对象")
public class DropDownUserLocation {

    @ApiModelProperty(value = "单位id", name = "unitId", example = "12321L")
    private Integer unitId;

    @ApiModelProperty(value = "用户id", name = "userId", example = "12321L")
    private Integer userId;

    @ApiModelProperty(value = "位置序号 1.A岗人员 2.B岗人员", name = "locationCode", example = "12321L")
    private Integer locationCode;
}
