package com.tykj.dev.device.user.base.ret;

import com.tykj.dev.misc.base.CustomPage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName UserConditionsVo.java
 * @Description 用户列表查询接口
 * @createTime 2020年08月23日 16:07:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "用户查询条件对象", description = "用户查询条件信息")
@Builder
public class UserConditionsVo extends CustomPage {
    @ApiModelProperty(value = "单位id", name = "unitsId", example = "12321L")
    private Integer unitsId;

    @ApiModelProperty(value = "模糊搜索", name = "dim", example = "12321L")
    private String dim;

    @ApiModelProperty(value = "类型" ,name = "type")
    private Integer type;
}
