package com.tykj.dev.device.user.cache;

import com.tykj.dev.device.user.subject.entity.Units;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Data
public class UnitsCache {

    private Map<Integer, Units> idMap;

    public UnitsCache(List<Units> unitsList){
        this.idMap = unitsList.stream().collect(Collectors.toMap(Units::getUnitId, Function.identity()));
    }

    public Map<Integer, Units> getIdMap() {
        return idMap;
    }

    public Units findById(Integer id) {
        return idMap.get(id);
    }

    public List<Units> findAll(){
        return new ArrayList<>(idMap.values());
    }

    public UnitsCache refresh(List<Units> unitsList){
        this.idMap = unitsList.stream().collect(Collectors.toMap(Units::getUnitId, Function.identity()));
        return this;
    }
}
