package com.tykj.dev.device.user.subject.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.user.subject.entity.Permissions;
import com.tykj.dev.device.user.subject.service.PermissionsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName PermissionsController.java
 * @Description 权限web层
 * @createTime 2020年07月28日 09:04:00
 */
@RestController
@AutoDocument
@Api(tags = "权限模块", description = "提供用户相关的接口")
@RequestMapping("/sys/auth")
public class PermissionsController {
    @Autowired
    PermissionsService permissionsService;

    @PostMapping(value = "/save")
    @ApiOperation(value = "权限添加接口", notes = "成功返回权限对象")
    public ResponseEntity addPermissions(@RequestBody Permissions permissions) {
        return ResponseEntity.ok(permissionsService.save(permissions));
    }

    @PostMapping(value = "/summary")
    @ApiOperation(value = "查询权限接口，按照类型划分，具体字段查看model", notes = "成功返回分类的权限对象")
    public ResponseEntity addPermissions() {
        return ResponseEntity.ok(permissionsService.findAllOrberPermissionsType());
    }


}
