package com.tykj.dev.device.user.subject.service.impl;

import com.github.wenhao.jpa.Specifications;
import com.tykj.dev.device.user.base.enums.AuExample;
import com.tykj.dev.device.user.subject.dao.AreaDao;
import com.tykj.dev.device.user.subject.dao.UnitsDao;
import com.tykj.dev.device.user.subject.entity.Area;
import com.tykj.dev.device.user.subject.entity.Units;
import com.tykj.dev.device.user.subject.entity.bto.AreaUnit;
import com.tykj.dev.device.user.subject.service.AuService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * AuServiceImpl.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/9/26 at 8:29 下午
 */
@Service
public class AuServiceImpl implements AuService {

    @Autowired
    private AreaDao areaRepo;

    @Autowired
    private UnitsDao unitsRepo;

    @Override
    public List<AreaUnit> findAll(AuExample example, Object value) {
        //解析条件
        if (example.getType() == 1) {
            Specification<Area> pred = Specifications.<Area>and()
                    .eq(Objects.nonNull(value), example.getFieldName(), value)
                    .build();
            List<Area> areaList = areaRepo.findAll(pred);

            List<AreaUnit> areaUnits = new ArrayList<>();
            for (Area area : areaList) {
                Units units = unitsRepo.findByAreaId(area.getId()).get(0);
                areaUnits.add(new AreaUnit(area, units));
            }

            return areaUnits;
        } else {
            Specification<Units> pred = Specifications.<Units>and()
                    .eq(Objects.nonNull(value), example.getFieldName(), value)
                    .build();

            List<Units> unitList = unitsRepo.findAll(pred);

            List<AreaUnit> areaUnits = new ArrayList<>();
            for (Units units : unitList) {
                Area area = areaRepo.findById(units.getAreaId()).get();
                areaUnits.add(new AreaUnit(area, units));
            }
            return areaUnits;
        }
    }

    @Override
    public AreaUnit findOne(AuExample example, Object value) {
        if (example.getType() == 1) {
            Specification<Area> pred = Specifications.<Area>and()
                    .eq(Objects.nonNull(value), example.getFieldName(), value)
                    .build();
            Area area = areaRepo.findOne(pred).orElse(Area.empty());
            Units units = unitsRepo.findByAreaIdEquals(area.getId());
            return new AreaUnit(area, units);

        } else {
            Specification<Units> pred = Specifications.<Units>and()
                    .eq(Objects.nonNull(value), example.getFieldName(), value)
                    .build();
            Units units = unitsRepo.findOne(pred).get();
            Area area = areaRepo.findById(units.getAreaId()).orElse(new Area(0, "省直属", 9999, "9999", 0, ""));
            return new AreaUnit(area, units);
        }
    }
}
