package com.tykj.dev.device.user.subject.service.impl;

import com.tykj.dev.device.user.base.req.VenitalisVo;
import com.tykj.dev.device.user.base.ret.RegistereRetVo;
import com.tykj.dev.device.user.subject.dao.UserDao;
import com.tykj.dev.device.user.subject.dao.UserLogDao;
import com.tykj.dev.device.user.subject.entity.User;
import com.tykj.dev.device.user.subject.entity.UserLog;
import com.tykj.dev.device.user.subject.entity.venaDigitalis.ContrastRet;
import com.tykj.dev.device.user.subject.entity.venaDigitalis.RegisteredRet;
import com.tykj.dev.device.user.subject.service.VenitalisService;
import com.tykj.dev.misc.exception.ApiException;
import com.tykj.dev.misc.utils.JacksonUtil;
import com.tykj.dev.misc.utils.httpclientutil.HttpClientUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName VenitalisServiceImpl.java
 * @Description TODO
 * @createTime 2020年11月12日 16:43:00
 */
@Service
@Slf4j
public class VenitalisServiceImpl implements VenitalisService {
    @Autowired
    private UserDao userDao;
    @Autowired
    private UserLogDao userLogDao;

//    private final static String http="http://10.153.4.11:8081";
    private final static String http="http://192.168.0.80:8081";
    private final static String REGISTERE="/api/v2/auth/register";
    private final static String CONTRAST="/api/v2/auth/identify";
    @Override
    public RegistereRetVo registeredRet(VenitalisVo venitalisVo) {
        User user= userDao.findById(venitalisVo.getUserId()).get();
        Map<String, Object> params=new HashMap<>();
        params.put("username","lingo");
        params.put("password","511B0D5F341BDDBD9A5348923B48D14C");
        params.put("id_type","06");
        params.put("uid",venitalisVo.getUserId());
        params.put("name",user.getName());
        if (user.getSex()==0){
            params.put("sex","1");
        }else {
            params.put("sex","2");
        }
        params.put("feature_item","ls");
        params.put("device_type","tg.VM661J.img");
        params.put("value",String.join(",",venitalisVo.getValue()));
        String ret= HttpClientUtil.httpPostRequest(http+REGISTERE,params);
        log.info("[指静脉] 注册请求返回：{}",ret);
        RegisteredRet registeredRet= JacksonUtil.readValue(ret,RegisteredRet.class);
        RegistereRetVo registereRetVo=new RegistereRetVo();
        if (registeredRet.getReg_result().equals("ok") && registeredRet.getResult_code().equals("ok")){
            registereRetVo.setRet(true);
            userLogDao.save(new UserLog(venitalisVo.getUserId(),new Date(),user.getName()+"注册了指静脉"));
            return registereRetVo;
        }else {
            registereRetVo.setRet(false);
            return registereRetVo;
        }
    }

    @Override
    public Integer contrastRet(String deviceType,String value) {

        Map<String, Object> params=new HashMap<>();
        params.put("username","lingo");
        params.put("password","511B0D5F341BDDBD9A5348923B48D14C");
        params.put("device_type","tg.VM661J.img");
        params.put("value",value);
        String ret= HttpClientUtil.httpPostRequest(http+CONTRAST,params);
        log.info("[指静脉] 认证请求返回：{}",ret);
        ContrastRet contrastRet= JacksonUtil.readValue(ret,ContrastRet.class);
        if (contrastRet.getResult_code().equals("ok") && contrastRet.getAuth_result()){
            return Integer.valueOf(contrastRet.getPersonVoList().get(0).getUid());
        }else {
          throw new ApiException(ResponseEntity.status(500).body(contrastRet));
        }

    }
}
