package com.tykj.dev.device.user.task;

import com.tykj.dev.device.user.subject.entity.Permissions;
import com.tykj.dev.device.user.subject.entity.Role;
import com.tykj.dev.device.user.subject.entity.RolePermissions;
import com.tykj.dev.device.user.subject.entity.UserRole;
import com.tykj.dev.device.user.subject.service.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName userRun.java
 * @Description TODO
 * @createTime 2020年07月28日 11:17:00
 */

@Slf4j
@Component
public class userRun implements CommandLineRunner {
    @Autowired
    UserService userService;

    @Autowired
    RoleService roleService;

    @Autowired
    UserRoleService userRoleService;

    @Autowired
    UnitsService unitsService;

    @Autowired
    PermissionsService permissionsService;

    @Autowired
    RolePermissionsService rolePermissionsService;

    @Override
    public void run(String... args) throws Exception {
        log.info("[用户] 项目启动初始化单位排序map开始");
        unitsService.addUnitSortMap();
        log.info("[用户] 项目启动初始化单位排序map完成");
    }

    private void permissionsRun() {
        permissionsService.save(new Permissions(1, "所有权限", "/**", 0));
        permissionsService.save(new Permissions(2, "所有权限", "/user/**", 0));
    }

    private void roleRun() {
        roleService.save(new Role(1, "管理员", "系统员", new Date(), null));
        roleService.save(new Role(2, "省A专管员", "系统员", new Date(), null));
        roleService.save(new Role(3, "省B专管员", "系统员", new Date(), null));
        roleService.save(new Role(4, "市A专管员", "系统员", new Date(), null));
        roleService.save(new Role(5, "市B专管员", "系统员", new Date(), null));
        roleService.save(new Role(6, "县A专管员", "系统员", new Date(), null));
        roleService.save(new Role(7, "县A专管员", "系统员", new Date(), null));
    }

    private void rolePerssionsRun() {
        roleService.findAll().forEach(
                role -> {
                    rolePermissionsService.save(new RolePermissions(null, role.getRoleId(), 1));
                    rolePermissionsService.save(new RolePermissions(null, role.getRoleId(), 2));
                }
        );
    }

    private void userRoleRun() {
        userRoleService.save(new UserRole(1, 1, 2));
        userRoleService.save(new UserRole(2, 2, 3));
        userRoleService.save(new UserRole(3, 3, 4));
        userRoleService.save(new UserRole(4, 4, 5));
        userRoleService.save(new UserRole(5, 5, 6));
        userRoleService.save(new UserRole(6, 6, 7));

    }


}
