package com.tykj.dev.device.usereport.service;

import com.tykj.dev.device.usereport.subject.domin.DeviceUseReport;
import com.tykj.dev.device.usereport.subject.vo.DeviceStatistics;
import com.tykj.dev.device.usereport.subject.vo.DeviceUseReportCreateVo;
import com.tykj.dev.device.usereport.subject.vo.DeviceUseReportSelectVo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.Date;
import java.util.List;

/**
 * @author dengdiyi
 */
public interface DeviceUseReportService {

    /**
     * @param deviceUseReportEntity 实体
     * 添加实体
     */
    DeviceUseReport addEntity(DeviceUseReport deviceUseReportEntity);

    /**
     * @param deviceUseReports 异步上链
     */
    void sendHash(List<DeviceUseReport> deviceUseReports);

    /**
     * @param deviceUseReportSelectVo 查询vo
     * @param pageable 分页
     * 获取使用报告分页
     */
    Page<DeviceUseReport> getPage(DeviceUseReportSelectVo deviceUseReportSelectVo, Pageable pageable);

    /**
     * @param id 报告id
     * 根据id获取使用报告
     */
    DeviceUseReport getOne(Integer id);

    /**
     * @param deviceUseReportEntity 实体
     * 更新实体
     */
    DeviceUseReport update(DeviceUseReport deviceUseReportEntity);

    /**
     * @param deviceUseReportCreateVo 创建vo
     * 生成装备使用报告
     */
    DeviceUseReport createReport(DeviceUseReportCreateVo deviceUseReportCreateVo);

    /**
     * @param startDate 开始时间
     * @param endDate   结束时间
     * @return 这一段时间省入库的统计
     */
    List<DeviceStatistics> getStorageStatistics(Date startDate, Date endDate);

    List<DeviceStatistics> getAllotStatistics(Date startDate, Date endDate);

    /**
     * @param startDate 开始时间
     * @param endDate   结束时间
     * @return 这一段时间省送国家维修的统计
     */
    List<DeviceStatistics> getRepairStatistics(Date startDate, Date endDate);


    /**
     * @param startDate 开始时间
     * @param endDate   结束时间
     * @return 这一段时间省送国家维修的统计
     */
    List<DeviceStatistics> getRepairBackStatistics(Date startDate, Date endDate);

    /**
     * 销毁根据时间查看装备数量
     * @param startDate 开始时间
     * @param endDate   结束时间
     * @return 数量
     */
    int getDestroyStatisticsCount(Date startDate, Date endDate);

    /**
     * @param startDate 开始时间
     * @param endDate   结束时间
     * @return 这一段时间省销毁的统计
     */
    List<DeviceStatistics> getDestroyStatistics(Date startDate, Date endDate);


    /**
     * 退役根据时间查看装备数量
     * @param startDate 开始时间
     * @param endDate   结束时间
     * @return 这一段时间省退役的统计
     */
    int getDecommissioningStatisticsCount(Date startDate, Date endDate);


    /**
     * @param startDate 开始时间
     * @param endDate   结束时间
     * @return 这一段时间省退役的统计
     */
    List<DeviceStatistics> getDecommissioningStatistics(Date startDate, Date endDate);


    /**
     * 报废根据时间查看装备数量
     * @param startDate 开始时间
     * @param endDate   结束时间
     * @return 这一段时间省报废的统计
     */
    int getScrapStatisticsCount(Date startDate, Date endDate);

    /**
     * @param startDate 开始时间
     * @param endDate   结束时间
     * @return 丢失数量
     */
    int getLossStatisticsCount(Date startDate, Date endDate);

    /**
     * @param startDate 开始时间
     * @param endDate   结束时间
     * @return 这一段时间省退役的统计
     */
    List<DeviceStatistics> getLossStatistics(Date startDate, Date endDate);

    /**
     * @param startDate 开始时间
     * @param endDate   结束时间
     * @return 这一段时间省报废的统计
     */
    List<DeviceStatistics> getScrapStatistics(Date startDate, Date endDate);


    void delete(Integer id);

}
