package com.tykj.dev.device.usereport.subject.vo;

import com.tykj.dev.device.file.entity.WrodParameter;
import com.tykj.dev.misc.base.BeanHelper;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.modelmapper.ModelMapper;

import java.util.Date;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("装备使用报告详情返回类")
public class DeviceUseReportDetailVo {
    @ApiModelProperty(value = "标题", example = "标题")
    private String title;
    @ApiModelProperty(value = "所属单位", example = "省机要局")
    private String unit;
    @ApiModelProperty(value = "装备类型总数", example = "100")
    private Integer deviceNumber;
    @ApiModelProperty(value = "入库数量", example = "10")
    private Integer inLibraryNum;
    @ApiModelProperty(value = "维修数量", example = "10")
    private Integer sendRepairNum;
    @ApiModelProperty(value = "维修退回", example = "10")
    private Integer receiveRepairNum;
    @ApiModelProperty(value = "销毁数量", example = "10")
    private Integer destoryNum;
    @ApiModelProperty(value = "发起配发数量", example = "10")
    private Integer sendAllotNum;
    @ApiModelProperty(value = "接收配发数量", example = "10")
    private Integer receiveAllotNum;
    @ApiModelProperty(value = "发起退回数量", example = "10")
    private Integer sendAllotBackNum;
    @ApiModelProperty(value = "接收退回", example = "10")
    private Integer receiveAllotBackNum;
    @ApiModelProperty(value = "清退数量", example = "10")
    private Integer sendBackNum;
    @ApiModelProperty(value = "报废数量", example = "10")
    private Integer scrapStatisticsNum;
    @ApiModelProperty(value = "列装数量", example = "10")
    private Integer packingNum;
    @ApiModelProperty(value = "退装数量", example = "10")
    private Integer retiredNum;
    @ApiModelProperty(value = "退役", example = "10")
    private Integer decommissioningStatisticsNum;
    @ApiModelProperty(value = "向下级进行维修退回", example = "10")
    private Integer toRepairBackNum;
    @ApiModelProperty(value = "接收下级进行维修", example = "10")
    private Integer toRepairNum;
    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "报告开始时间")
    private Date startTime;

    @ApiModelProperty(value = "报告结束时间")
    private Date endTime;

    public WrodParameter toWrodParameter(){
        ModelMapper mapper = BeanHelper.getUserMapper();
        return mapper.map(this, WrodParameter.class);
    }
}
