## 开发流程与规范

### 业务流程

- [核查模块业务流程](docs/confirm_check.md)

### 开发流程

![装备开发部署流程](/images/装备开发部署流程.jpg)


**组长流程**

两份文档 - changelog(自生成) 组员任务表(分发任务)

1. 获得任务，设定里程碑的目标与截止时间
2. 分发任务给开发人员
3. 开发人员领取任务，在自己本地完成后与前端对接测试完毕后提交到DEV(以整块的任务需求来提交)
4. 组长在确认无误后，生成changeLog,在Gitlab上合并到master上，关闭相关issuse
5. 里程碑完成后，在master中打tag

**开发人员需要知道的**

- stash与pop 相关的操作
- 出现部分功能要先上了 先做代码分割

### Commit的规范

#### Commit格式

```
<type>(<scope>): <subject>
// 空一行
<body>
// 空一行
<footer>
```

**type**

- feat：新功能（feature）
- fix：修补bug
- docs：文档（documentation）
- style： 格式（不影响代码运行的变动）
- refactor：重构（即不是新增功能，也不是修改bug的代码变动）
- test：增加测试
- chore：构建过程或辅助工具的变动

ps : 如果`type`为`feat`和`fix`，则该 commit 将肯定出现在 Change log 之中。

**scope**

为模块名，例如核查模块

**subject**

关于项目的简短描述，不超过50个字

**Body**

- Body 部分是对本次 commit 的详细描述，可以分成多行。

- 应该说明代码变动的动机，以及与以前行为的对比。

**Footer**

- 如果当前 commit 针对某个issue，那么可以在 Footer 部分关闭这个 issue 。例如

  ```
  Closes #234
  ```



###  Git commit template模板Commit

**安装**
plugins里安装

### 自动生成changeLog
- 安装 `npm install -g commitizen`
- 安装 `npm install cz-conventional-changelog --save-dev`
- 安装 `npm install -g conventional-changelog-cli`
  配置`package.json`
```
{
  "devDependencies": {
    "commitizen": "^4.0.3",
    "cz-conventional-changelog": "^3.0.2"
  },
  "config": {
    "commitizen": {
      "path": "./node_modules/cz-conventional-changelog"
    }
  },
  "version": "1.0.2",
  "scripts": {
    "changelog": "conventional-changelog -p angular -i CHANGELOG.md -s -r 0 && git add CHANGELOG.md"
    }
}
```
### 生成changelog
- 追加 `conventional-changelog -p angular -i CHANGELOG.md -s `
- 全部生成 `conventional-changelog -p angular -i CHANGELOG.md -s -r 0`

### 组长发布的流程
- 在`dev`分支中生成changelog,随后push到仓库的dev分支中
- 在gitlab上进行合并，将dev的内容合并到master中
- 主场在本地拉取master内容，打tag，推送到远端仓库。

## 流水线信息
- jenkins地址 `http://192.168.100.247:8080`






