/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.commandline.commands.internal;

import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.commandline.commands.internal.Command;
import com.zebra.sdk.commandline.internal.Option;
import com.zebra.sdk.commandline.internal.ParsedArguments;
import com.zebra.sdk.commandline.internal.ZebraCommandConstants;
import com.zebra.sdk.device.ProfileToMirrorServer;
import com.zebra.sdk.util.internal.Range;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;

public class UploadProfileToMirrorServerCommand
extends Command {
    private static final Option FTP_USERNAME_OPTION = new Option("u", "username", "FTP Username").addArg("user", true);
    private static final Option FTP_PASSWORD_OPTION = new Option("p", "password", "FTP Password").addArg("pass", true);
    private static final int FTP_SERVER = 0;
    private static final int ZPROFILE_INDEX = 1;

    public UploadProfileToMirrorServerCommand() {
        this.options.add(FTP_USERNAME_OPTION);
        this.options.add(FTP_PASSWORD_OPTION);
    }

    @Override
    public String getCommandName() {
        return "mirror";
    }

    @Override
    public String getDescription() {
        return "Uploads a zprofile to a mirror server";
    }

    @Override
    public void run(ParsedArguments parsedArguments) throws Exception {
        if (!parsedArguments.containsOption(FTP_USERNAME_OPTION) || !parsedArguments.containsOption(FTP_PASSWORD_OPTION)) {
            throw new IllegalArgumentException("Must specify both username and password.");
        }
        String string = parsedArguments.getArg(1);
        String string2 = parsedArguments.getArg(0);
        this.verboseFormatPrint("Sending %s to %s", string, string2);
        String string3 = parsedArguments.getOptionArgument(FTP_USERNAME_OPTION);
        String string4 = parsedArguments.getOptionArgument(FTP_PASSWORD_OPTION);
        List<String> list = this.sendToMirrorServer(string, string2, string3, string4);
        if (list.size() > 0) {
            this.verbosePrint("Errors!");
            for (String string5 : list) {
                System.out.println(string5);
            }
        }
    }

    protected List<String> sendToMirrorServer(String string, String string2, String string3, String string4) throws ConnectionException, FileNotFoundException, IOException {
        return new ProfileToMirrorServer(string).sendToMirrorServer(string2, string3, string4);
    }

    @Override
    protected Range getExpectedArgRange() {
        return ZebraCommandConstants.TWO_ARG_RANGE;
    }

    @Override
    public String getHelpMessage() {
        return this.getDefaultHelpWithCustomUsage(String.format("usage: %s %s <server> <profileFile> [<options>]%n", "java -jar ZSDK_API.jar", this.getCommandName()));
    }

    @Override
    public String getExamples() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Store a profile onto an ftp server\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 /path/to/profile.zprofile --username user --password hunter2%n", "java -jar ZSDK_API.jar", this.getCommandName()));
        return stringBuilder.toString();
    }
}

