/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.internal;

import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.graphics.internal.CpclCrcHeader;
import com.zebra.sdk.graphics.internal.DitheredImageProvider;
import com.zebra.sdk.graphics.internal.ZebraImageInternal;
import com.zebra.sdk.printer.internal.GraphicsConvertionUtil;
import com.zebra.sdk.printer.internal.RleEncodedImage;
import com.zebra.sdk.util.internal.FileUtilities;
import com.zebra.sdk.util.internal.PrinterFilePath;
import com.zebra.sdk.util.internal.StringUtilities;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class GraphicsConversionUtilCpcl
implements GraphicsConvertionUtil {
    @Override
    public void sendImageToStream(String string, ZebraImageInternal zebraImageInternal, int n, int n2, OutputStream outputStream) throws ZebraIllegalArgumentException, IOException {
        zebraImageInternal.scaleImage(n, n2);
        byte[] byArray = this.createPcxImage(n, n2, zebraImageInternal);
        String string2 = "! CISDFCRC16";
        String string3 = CpclCrcHeader.getCRC16ForCertificateFilesOnly(byArray).toUpperCase();
        String string4 = GraphicsConversionUtilCpcl.getCorrectedFileName(string);
        String string5 = StringUtilities.convertTo8dot3(string4);
        String string6 = StringUtilities.stringPadToPlaces(8, "0", Integer.toHexString(byArray.length).toUpperCase());
        String string7 = CpclCrcHeader.getWChecksum(byArray).toUpperCase();
        byte[] byArray2 = "\r\n".getBytes();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(string2.getBytes(), 0, string2.length());
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        byteArrayOutputStream.write(string3.getBytes(), 0, string3.length());
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        byteArrayOutputStream.write(string5.getBytes(), 0, string5.length());
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        byteArrayOutputStream.write(string6.getBytes(), 0, string6.length());
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        byteArrayOutputStream.write(string7.getBytes(), 0, string7.length());
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        outputStream.write(byteArrayOutputStream.toByteArray());
        byteArrayOutputStream.close();
    }

    private static String getCorrectedFileName(String string) throws ZebraIllegalArgumentException {
        PrinterFilePath printerFilePath = FileUtilities.parseDriveAndExtension(string);
        String string2 = printerFilePath.getFileName();
        return string2 + ".PCX";
    }

    public byte[] createPcxHeader(int n, int n2) throws IOException {
        int n3;
        byte[] byArray = new byte[]{10, 5, 1, 1};
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(byArray);
        byte[] byArray2 = new byte[]{0, 0, 0, 0};
        byteArrayOutputStream.write(byArray2);
        byte[] byArray3 = this.integerToLittleEndianByteArray(n - 1);
        byteArrayOutputStream.write(byArray3);
        byte[] byArray4 = this.integerToLittleEndianByteArray(n2 - 1);
        byteArrayOutputStream.write(byArray4);
        byte[] byArray5 = new byte[]{-56, 0, -56, 0};
        byteArrayOutputStream.write(byArray5);
        for (n3 = 0; n3 < 48; ++n3) {
            byteArrayOutputStream.write(0);
        }
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(1);
        n3 = GraphicsConversionUtilCpcl.getWidthOfImage(n);
        char c = (char)(n3 + (char)(n3 % 2));
        byte[] byArray6 = this.integerToLittleEndianByteArray(c);
        byteArrayOutputStream.write(byArray6);
        byte[] byArray7 = new byte[]{0, 0};
        byteArrayOutputStream.write(byArray7);
        for (int i = 0; i < 58; ++i) {
            byteArrayOutputStream.write(0);
        }
        return byteArrayOutputStream.toByteArray();
    }

    byte[] integerToLittleEndianByteArray(int n) {
        byte[] byArray = new byte[]{(byte)n, (byte)(n >>> 8 & 0xFF)};
        return byArray;
    }

    private static int getWidthOfImage(int n) {
        return (n + 7) / 8;
    }

    public byte[] createPcxImage(int n, int n2, byte[] byArray) throws IOException {
        int n3 = GraphicsConversionUtilCpcl.getWidthOfImage(n);
        byte[] byArray2 = new RleEncodedImage().rleEncoding(byArray, n3);
        byte[] byArray3 = this.createPcxHeader(n, n2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(byArray3);
        byteArrayOutputStream.write(byArray2);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] createPcxImage(int n, int n2, ZebraImageInternal zebraImageInternal) throws IOException {
        if (n <= 0) {
            n = zebraImageInternal.getWidth();
        }
        if (n2 <= 0) {
            n2 = zebraImageInternal.getHeight();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DitheredImageProvider.getDitheredImage(zebraImageInternal, byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byte[] byArray2 = this.createPcxImage(n, n2, byArray);
        byteArrayOutputStream.close();
        return byArray2;
    }
}

