/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.settings.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.settings.Setting;
import com.zebra.sdk.settings.SettingsException;
import com.zebra.sdk.settings.internal.ConnectionUtil;
import com.zebra.sdk.settings.internal.JsonHelper;
import com.zebra.sdk.settings.internal.JsonValidator;
import com.zebra.sdk.settings.internal.ZebraSettingsList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ZebraSettingsListFromConnection
extends ZebraSettingsList {
    private Connection connection;

    public ZebraSettingsListFromConnection(Connection connection) {
        this.connection = connection;
    }

    @Override
    protected byte[] getUpdatedJsonData() throws Exception {
        Connection connection = ConnectionUtil.selectConnection(this.connection);
        return connection.sendAndWaitForValidResponse("{}{\"allconfig\":null}".getBytes(), connection.getMaxTimeoutForRead(), connection.getTimeToWaitForMoreData(), new JsonValidator());
    }

    @Override
    public Map<String, String> getValues(List<String> list) throws SettingsException, ConnectionException, ZebraIllegalArgumentException {
        List<String> list2 = this.filterOutUnreadableSettings(list);
        return this.doJsonQuery(list2);
    }

    private Map<String, String> doJsonQuery(List<String> list) throws ConnectionException, ZebraIllegalArgumentException {
        byte[] byArray = JsonHelper.buildQuery(list);
        Connection connection = ConnectionUtil.selectConnection(this.connection);
        byte[] byArray2 = connection.sendAndWaitForValidResponse(byArray, connection.getMaxTimeoutForRead(), connection.getTimeToWaitForMoreData(), new JsonValidator());
        return JsonHelper.parseGetResponse(byArray2);
    }

    @Override
    public void setSetting(String string, String string2) throws SettingsException {
        this.updateInternalState(string, string2);
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put(string, string2);
        this.storeSettingValues(linkedHashMap);
    }

    @Override
    public void setSettings(Map<String, String> map) throws SettingsException {
        this.updateSettingsWithResponse(map);
    }

    private byte[] updateSettingsWithResponse(Map<String, String> map) throws SettingsException {
        for (String string : map.keySet()) {
            try {
                if (map.get(string) == null) continue;
                this.updateInternalState(string, map.get(string));
            }
            catch (SettingsException settingsException) {}
        }
        return this.storeSettingValues(map);
    }

    @Override
    public Map<String, String> processSettingsViaMap(Map<String, String> map) throws SettingsException {
        Map<String, String> map2 = null;
        byte[] byArray = this.updateSettingsWithResponse(map);
        try {
            map2 = JsonHelper.parseGetResponse(byArray);
        }
        catch (ZebraIllegalArgumentException zebraIllegalArgumentException) {
            throw new SettingsException(zebraIllegalArgumentException.getLocalizedMessage());
        }
        return map2;
    }

    private byte[] storeSettingValues(Map<String, String> map) throws SettingsException {
        byte[] byArray = JsonHelper.buildSetCommand(map);
        byte[] byArray2 = null;
        Connection connection = ConnectionUtil.selectConnection(this.connection);
        try {
            byArray2 = connection.sendAndWaitForValidResponse(byArray, connection.getMaxTimeoutForRead(), connection.getTimeToWaitForMoreData(), new JsonValidator());
        }
        catch (ConnectionException connectionException) {
            throw new SettingsException(connectionException.getMessage());
        }
        return byArray2;
    }

    @Override
    public void setSetting(String string, Setting setting) {
    }

    @Override
    public void setAllSettings(Map<String, Setting> map) throws SettingsException {
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }
}

