package com.tykj.dev.device.library.service.impl;

import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.dev.device.library.repository.DeviceLibraryDao;
import com.tykj.dev.device.library.service.DeviceLibraryService;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.library.subject.vo.DeviceLibrarySelectVo;
import com.tykj.dev.device.user.subject.service.UserPublicService;
import com.tykj.dev.device.user.util.UserUtils;
import com.tykj.dev.misc.exception.ApiException;
import com.tykj.dev.misc.utils.GetTreeUtils;
import com.tykj.dev.misc.utils.ResultUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import javax.persistence.Column;
import java.lang.reflect.Field;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author dengdiyi
 */
@Service
public class DeviceLibraryServiceImpl implements DeviceLibraryService {

    @Autowired
    private DeviceLibraryDao deviceLibraryDao;

    @Autowired
    UserUtils userUtils;

    @Autowired
    private UserPublicService userPublicService;

//    @Autowired
//    private StorageBillService storageBillService;

    @Override
    public DeviceLibrary addEntity(DeviceLibrary deviceLibraryEntity) {
        return deviceLibraryDao.save(deviceLibraryEntity);
    }

    @Override
    public List<DeviceLibrary> addEntityList(List<DeviceLibrary> list) {
        return null;
    }

    @Override
    public Page<DeviceLibrary> getPage(DeviceLibrarySelectVo deviceLibrarySelectVo, Pageable pageable) {
        Specification<DeviceLibrary> selectSpecification = getSelectSpecification(deviceLibrarySelectVo);
        return deviceLibraryDao.findAll(selectSpecification, pageable);
    }

    @Override
    public Page<DeviceLibrary> getTagPage(DeviceLibrarySelectVo deviceLibrarySelectVo, Pageable pageable) {
        return deviceLibraryDao.findAll(getSelectSpecification4(deviceLibrarySelectVo),deviceLibrarySelectVo.getPageable());
    }

    @Override
    public List<DeviceLibrary> getAllotPage(DeviceLibrarySelectVo deviceLibrarySelectVo) {
        return deviceLibraryDao.findAll(getAllotSelectSpecification(deviceLibrarySelectVo));
    }

    @Override
    public Page<DeviceLibrary> getCoreDevicePage(DeviceLibrarySelectVo deviceLibrarySelectVo, Pageable pageable) {
        Integer selectUnitId = deviceLibrarySelectVo.getUnitId();
        Integer selectAreaId = deviceLibrarySelectVo.getAreaId();
        if (selectAreaId==null) {
            List<DeviceLibrary> libraryEntities;
            if (selectUnitId==null) {
                libraryEntities = getList2(deviceLibrarySelectVo);
            }
            else {
                String unitName = userPublicService.findByUnitsToname(selectUnitId);
                libraryEntities = getList3(deviceLibrarySelectVo,unitName);
            }
            List<DeviceLibrary> resultList = new ArrayList<>();
            for (DeviceLibrary d:libraryEntities) {
                resultList.add(d);
                if (d.getChilds().size()>0){
                    resultList.addAll(d.getChilds());
                }
            }
            if (resultList.size()<=deviceLibrarySelectVo.getSize()) {
                return new PageImpl<>(resultList, pageable, resultList.size());
            }
            else {
                Double d = Math.ceil(resultList.size()/deviceLibrarySelectVo.getSize().doubleValue());
                int num = new Double(d).intValue();
                if (deviceLibrarySelectVo.getPage()>=num){
                    return null;
                }
                else {
                    int index = deviceLibrarySelectVo.getPage()*deviceLibrarySelectVo.getSize();
                    if (deviceLibrarySelectVo.getPage()==num-1){
                        return new PageImpl<>(resultList.subList(index,resultList.size()), pageable, resultList.size());
                    }
                    return new PageImpl<>(resultList.subList(index,index+deviceLibrarySelectVo.getSize()), pageable, resultList.size());
                }
            }
        }
        else {
            Integer selectLevel = userPublicService.getArea(selectAreaId).getType();
            List<String> units = userPublicService.findAllUnitNameByAreaId(selectAreaId);
            if (selectLevel==3||selectLevel==2){
                List<DeviceLibrary> libraryEntities = deviceLibraryDao.findAll().stream().filter(deviceLibraryEntity -> units.contains(deviceLibraryEntity.getOwnUnit())).collect(Collectors.toList());
                List<DeviceLibrary> resultList = new ArrayList<>();
                for (DeviceLibrary d:libraryEntities) {
                    resultList.add(d);
                    if (d.getChilds().size()>0){
                        resultList.addAll(d.getChilds());
                    }
                }
                if (resultList.size()<=deviceLibrarySelectVo.getSize()) {
                    return new PageImpl<>(resultList, pageable, resultList.size());
                }
                else {
                    Double d = Math.ceil(resultList.size()/deviceLibrarySelectVo.getSize().doubleValue());
                    int num = new Double(d).intValue();
                    if (deviceLibrarySelectVo.getPage()>=num){
                        return null;
                    }
                    else {
                        int index = deviceLibrarySelectVo.getPage()*deviceLibrarySelectVo.getSize();
                        if (deviceLibrarySelectVo.getPage()==num-1){
                            return new PageImpl<>(resultList.subList(index,resultList.size()), pageable, resultList.size());
                        }
                        return new PageImpl<>(resultList.subList(index,index+deviceLibrarySelectVo.getSize()), pageable, resultList.size());
                    }
                }
            }
            if (selectLevel==1){
                List<DeviceLibrary> libraryEntities = deviceLibraryDao.findAll();
                List<DeviceLibrary> resultList = new ArrayList<>();
                for (DeviceLibrary d:libraryEntities) {
                    resultList.add(d);
                    if (d.getChilds().size()>0){
                        resultList.addAll(d.getChilds());
                    }
                }
                if (resultList.size()<=deviceLibrarySelectVo.getSize()) {
                    return new PageImpl<>(resultList, pageable, resultList.size());
                }
                else {
                    Double d = Math.ceil(resultList.size()/deviceLibrarySelectVo.getSize().doubleValue());
                    int num = new Double(d).intValue();
                    if (deviceLibrarySelectVo.getPage()>=num){
                        return null;
                    }
                    else {
                        int index = deviceLibrarySelectVo.getPage()*deviceLibrarySelectVo.getSize();
                        if (deviceLibrarySelectVo.getPage()==num-1){
                            return new PageImpl<>(resultList.subList(index,resultList.size()), pageable, resultList.size());
                        }
                        return new PageImpl<>(resultList.subList(index,index+deviceLibrarySelectVo.getSize()), pageable, resultList.size());
                    }
                }
            }
            else{
                throw new ApiException(ResultUtil.failed());
            }
        }
    }

//    @Override
//    public Page<DeviceStatisticsVo> getDeviceStatisticsPage(DeviceLibrarySelectVo deviceLibrarySelectVo, Pageable pageable) {
//        List<String> list = getAllModel();
//        List<DeviceStatisticsVo> deviceStatisticsVos = new ArrayList<>();
//        DeviceLibrarySelectVo d = new DeviceLibrarySelectVo();
//        BeanUtils.copyProperties(deviceLibrarySelectVo,d);
//        d.setSize(Integer.MAX_VALUE);
//        List<DeviceLibrary> libraryEntities = getCoreDevicePage(d,d.getPageable()).getContent();
//        if (libraryEntities.size()>0) {
//            for (String model : list) {
//                DeviceStatisticsVo deviceStatisticsVo = new DeviceStatisticsVo();
//                deviceStatisticsVo.setModel(model);
//                Integer num = 0;
//                Integer inLibraryNum = 0;
//                Integer repairNum = 0;
//                Integer destoryNum = 0;
//                Integer scrappedNum = 0;
//                Integer allotNum = 0;
//                Integer retiredNum = 0;
//                Integer useNum = 0;
//                for (DeviceLibrary d2 : libraryEntities) {
//                    if (d2.getModel().equals(model)) {
//                        deviceStatisticsVo.setName(d2.getName());
//                        num++;
//                        switch (d2.getLifeStatus()) {
//                            case 2:
//                                inLibraryNum++;
//                                break;
//                            case 3:
//                                allotNum++;
//                                break;
//                            case 4:
//                                repairNum++;
//                                break;
//                            case 5:
//                                scrappedNum++;
//                                break;
//                            case 6:
//                                allotNum++;
//                                break;
//                            case 12:
//                                retiredNum++;
//                                break;
//                            case 9:
//                                destoryNum++;
//                                break;
//                            case 10:
//                                destoryNum++;
//                                break;
//                            case 13:
//                                scrappedNum++;
//                                break;
//                            case 14:
//                                useNum++;
//                                break;
//                            default:
//                                break;
//                        }
//                    }
//                }
//                if (num > 0) {
//                    deviceStatisticsVo.setDeviceNumber(num);
//                    deviceStatisticsVo.setAllotNum(allotNum);
//                    deviceStatisticsVo.setInLibraryNum(inLibraryNum);
//                    deviceStatisticsVo.setRepairNum(repairNum);
//                    deviceStatisticsVo.setDestoryNum(destoryNum);
//                    deviceStatisticsVo.setScrappedNum(scrappedNum);
//                    deviceStatisticsVo.setRetiredNum(retiredNum);
//                    deviceStatisticsVo.setUseNum(useNum);
//                    deviceStatisticsVos.add(deviceStatisticsVo);
//                }
//
//            }
//
//            if (deviceStatisticsVos.size() <= deviceLibrarySelectVo.getSize()) {
//                return new PageImpl<>(deviceStatisticsVos, pageable, deviceStatisticsVos.size());
//            } else {
//                Double v = Math.ceil(deviceStatisticsVos.size() / deviceLibrarySelectVo.getSize().doubleValue());
//                int value = new Double(v).intValue();
//                if (deviceLibrarySelectVo.getPage() >= value) {
//                    return null;
//                } else {
//                    int index = deviceLibrarySelectVo.getPage() * deviceLibrarySelectVo.getSize();
//                    if (deviceLibrarySelectVo.getPage() == value - 1) {
//                        return new PageImpl<>(deviceStatisticsVos.subList(index, deviceStatisticsVos.size()), pageable, deviceStatisticsVos.size());
//                    }
//                    return new PageImpl<>(deviceStatisticsVos.subList(index, index + deviceLibrarySelectVo.getSize()), pageable, deviceStatisticsVos.size());
//                }
//            }
//        }
//        return new PageImpl<>(deviceStatisticsVos, pageable, deviceStatisticsVos.size());
//    }

    @Override
    public List<String> getAllName() {
        List<DeviceLibrary> strings = deviceLibraryDao.findAll();
        Set<String> s = new HashSet<>();
        for (DeviceLibrary d:strings) {
            s.add(d.getName());
        }
        return new ArrayList<>(s);
    }

    @Override
    public List<DeviceLibrary> getList(DeviceLibrarySelectVo deviceLibrarySelectVo) {
        List<DeviceLibrary> deviceLibraryEntities = deviceLibraryDao.findAll(getSelectSpecification(deviceLibrarySelectVo));
        Map<Integer, DeviceLibrary> nodeCollect =
                deviceLibraryEntities.stream().collect(Collectors.toMap(DeviceLibrary::getId, deviceLibraryEntity -> deviceLibraryEntity));
        List<DeviceLibrary> deviceLibraryEntities1 = GetTreeUtils.parseTreeFromDown(
                deviceLibraryEntities,
                DeviceLibrary::getId,
                deviceLibraryEntity -> Optional.ofNullable(nodeCollect.get(deviceLibraryEntity.getPartParentId())),
                DeviceLibrary::addChildNode
        );
        return deviceLibraryEntities1;
    }

    public List<DeviceLibrary> getList2(DeviceLibrarySelectVo deviceLibrarySelectVo) {
        List<DeviceLibrary> deviceLibraryEntities = deviceLibraryDao.findAll(getSelectSpecification6(deviceLibrarySelectVo));
        Map<Integer, DeviceLibrary> nodeCollect =
                deviceLibraryEntities.stream().collect(Collectors.toMap(DeviceLibrary::getId, deviceLibraryEntity -> deviceLibraryEntity));
        List<DeviceLibrary> deviceLibraryEntities1 = GetTreeUtils.parseTreeFromDown(
                deviceLibraryEntities,
                DeviceLibrary::getId,
                deviceLibraryEntity -> Optional.ofNullable(nodeCollect.get(deviceLibraryEntity.getPartParentId())),
                DeviceLibrary::addChildNode
        );
        return deviceLibraryEntities1;
    }

    public List<DeviceLibrary> getList3(DeviceLibrarySelectVo deviceLibrarySelectVo,String name) {
        List<DeviceLibrary> deviceLibraryEntities = deviceLibraryDao.findAll(getSelectSpecification2(deviceLibrarySelectVo,name));
        Map<Integer, DeviceLibrary> nodeCollect =
                deviceLibraryEntities.stream().collect(Collectors.toMap(DeviceLibrary::getId, deviceLibraryEntity -> deviceLibraryEntity));
        List<DeviceLibrary> deviceLibraryEntities1 = GetTreeUtils.parseTreeFromDown(
                deviceLibraryEntities,
                DeviceLibrary::getId,
                deviceLibraryEntity -> Optional.ofNullable(nodeCollect.get(deviceLibraryEntity.getPartParentId())),
                DeviceLibrary::addChildNode
        );
        return deviceLibraryEntities1;
    }

    @Override
    public List<DeviceLibrary> getListWithoutParent(DeviceLibrarySelectVo deviceLibrarySelectVo) {
        List<DeviceLibrary> deviceLibraryEntities = deviceLibraryDao.findAll(getSelectSpecification(deviceLibrarySelectVo));

        return deviceLibraryEntities;
    }

    @Override
    public List<String> getAllUnit() {
        List<DeviceLibrary> strings = deviceLibraryDao.findAll();
        Set<String> s = new HashSet<>();
        for (DeviceLibrary d:strings) {
            s.add(d.getOwnUnit());
        }
        return new ArrayList<>(s);
    }

    @Override
    public List<DeviceLibrary> getAllList(DeviceLibrarySelectVo deviceLibrarySelectVo) {
        return deviceLibraryDao.findAll(getSelectSpecification4(deviceLibrarySelectVo));
    }

    @Override
    public List<DeviceLibrary> getCheckList() {
        PredicateBuilder<DeviceLibrary> predicateBuilder = Specifications.and();
        predicateBuilder.eq("ownUnit",userUtils.getCurrentUserUnitName());
        predicateBuilder.eq("lifeStatus",2);
        return deviceLibraryDao.findAll(predicateBuilder.build());
    }

    @Override
    public List<DeviceLibrary> getAllotList(DeviceLibrarySelectVo deviceLibrarySelectVo) {
        List<DeviceLibrary> deviceLibraryEntities = deviceLibraryDao.findAll(getAllotSelectSpecification(deviceLibrarySelectVo));
        Map<Integer, DeviceLibrary> nodeCollect =
                deviceLibraryEntities.stream().collect(Collectors.toMap(DeviceLibrary::getId, deviceLibraryEntity -> deviceLibraryEntity));
        List<DeviceLibrary> deviceLibraryEntities1 = GetTreeUtils.parseTreeFromDown(
                deviceLibraryEntities,
                DeviceLibrary::getId,
                deviceLibraryEntity -> Optional.ofNullable(nodeCollect.get(deviceLibraryEntity.getPartParentId())),
                DeviceLibrary::addChildNode
        );
        return deviceLibraryEntities1;
    }

    @Override
    public List<DeviceLibrary> getListByBillId(Integer id) {
        PredicateBuilder<DeviceLibrary> predicateBuilder = Specifications.and();
        predicateBuilder.eq("storageBillId",id);
        return deviceLibraryDao.findAll(predicateBuilder.build());
    }


    @Override
    public DeviceLibrary update(DeviceLibrary deviceLibraryEntity) {
        return deviceLibraryDao.save(deviceLibraryEntity);
    }

    @Override
    public DeviceLibrary getOne(Integer id) {
        Optional<DeviceLibrary> deviceLibraryEntity = deviceLibraryDao.findById(id);
        return deviceLibraryEntity.orElse(null);
    }

    @Override
    public void delete(Integer id) {
        deviceLibraryDao.deleteById(id);
    }

    private Specification<DeviceLibrary> getSelectSpecification(DeviceLibrarySelectVo deviceLibrarySelectVo){
        PredicateBuilder<DeviceLibrary> predicateBuilder = getPredicateBuilder(deviceLibrarySelectVo);
        if (deviceLibrarySelectVo.getUnitId()==null){
            String unit = userUtils.getCurrentUserUnitName();
            predicateBuilder.eq("ownUnit",unit);
        }
        else {
            String unit = userPublicService.findByUnitsToname(deviceLibrarySelectVo.getUnitId());
            predicateBuilder.eq("ownUnit",unit);
        }
        return predicateBuilder.build();
    }

    private Specification<DeviceLibrary> getSelectSpecification2(DeviceLibrarySelectVo deviceLibrarySelectVo,String name){
        PredicateBuilder<DeviceLibrary> predicateBuilder = getPredicateBuilder(deviceLibrarySelectVo);
        predicateBuilder.eq("ownUnit",name);
        return predicateBuilder.build();
    }

    private Specification<DeviceLibrary> getSelectSpecification3(DeviceLibrarySelectVo deviceLibrarySelectVo){
        PredicateBuilder<DeviceLibrary> predicateBuilder = getPredicateBuilder(deviceLibrarySelectVo);
        String unit = userUtils.getCurrentUserUnitName();
        predicateBuilder.eq("ownUnit",unit);
        predicateBuilder.eq("isPart",1);
        return predicateBuilder.build();
    }

    private Specification<DeviceLibrary> getSelectSpecification4(DeviceLibrarySelectVo deviceLibrarySelectVo){
        PredicateBuilder<DeviceLibrary> predicateBuilder = getPredicateBuilder(deviceLibrarySelectVo);
        return predicateBuilder.build();
    }

    private Specification<DeviceLibrary> getSelectSpecification5(DeviceLibrarySelectVo deviceLibrarySelectVo){
        PredicateBuilder<DeviceLibrary> predicateBuilder = getPredicateBuilder(deviceLibrarySelectVo);
        predicateBuilder.eq("isPart",1);
        return predicateBuilder.build();
    }

    private Specification<DeviceLibrary> getSelectSpecification6(DeviceLibrarySelectVo deviceLibrarySelectVo){
        PredicateBuilder<DeviceLibrary> predicateBuilder = getPredicateBuilder(deviceLibrarySelectVo);
        if (deviceLibrarySelectVo.getUnitId()==null){
            String unit = userUtils.getCurrentUserUnitName();
            predicateBuilder.eq("ownUnit",unit);
        }
        return predicateBuilder.build();
    }

    private Specification<DeviceLibrary> getAllotSelectSpecification(DeviceLibrarySelectVo deviceLibrarySelectVo){
        PredicateBuilder<DeviceLibrary> predicateBuilder = getPredicateBuilder(deviceLibrarySelectVo);
        String unit = userUtils.getCurrentUserUnitName();
        predicateBuilder.eq("ownUnit",unit);
        predicateBuilder.eq("lifeStatus",2);
        return predicateBuilder.build();
    }

    private Specification<DeviceLibrary> getStatisticsSelectSpecification(DeviceLibrarySelectVo deviceLibrarySelectVo){
        PredicateBuilder<DeviceLibrary> predicateBuilder = getPredicateBuilder(deviceLibrarySelectVo);
        String unit = userUtils.getCurrentUserUnitName();
        return predicateBuilder.build();
    }

    private PredicateBuilder<DeviceLibrary> getPredicateBuilder(DeviceLibrarySelectVo deviceLibrarySelectVo){
        PredicateBuilder<DeviceLibrary> predicateBuilder = Specifications.and();
        if (deviceLibrarySelectVo!=null) {
            if (deviceLibrarySelectVo.getModel()!=null){
                predicateBuilder.eq("model",deviceLibrarySelectVo.getModel());
            }
            if (deviceLibrarySelectVo.getName()!=null){
                predicateBuilder.eq("name",deviceLibrarySelectVo.getName());
            }
            if (deviceLibrarySelectVo.getSecretLevel()!=null){
                predicateBuilder.eq("secretLevel",deviceLibrarySelectVo.getSecretLevel());
            }
            if (deviceLibrarySelectVo.getMatchingRange()!=null){
                predicateBuilder.eq("matchingRange",deviceLibrarySelectVo.getMatchingRange());
            }
            if (deviceLibrarySelectVo.getStorageType()!=null){
                predicateBuilder.eq("storageType",deviceLibrarySelectVo.getStorageType());
            }
            if (deviceLibrarySelectVo.getManageStatus()!=null){
                predicateBuilder.eq("manageStatus",deviceLibrarySelectVo.getManageStatus());
            }
            if (deviceLibrarySelectVo.getLifeStatus()!=null){
                predicateBuilder.in("lifeStatus",deviceLibrarySelectVo.getLifeStatus().toArray(new Integer[]{}));
            }
            if (deviceLibrarySelectVo.getType()!=null){
                predicateBuilder.eq("type",deviceLibrarySelectVo.getType());
            }
            if (deviceLibrarySelectVo.getInvisibleRange()!=null){
                predicateBuilder.eq("invisibleRange",deviceLibrarySelectVo.getInvisibleRange());
            }
            if (deviceLibrarySelectVo.getInvisibleRange()!=null){
                predicateBuilder.eq("locationUnit",deviceLibrarySelectVo.getLocationUnit());
            }
            if (deviceLibrarySelectVo.getRfidCardId()!=null){
                predicateBuilder.eq("rfidCardId",deviceLibrarySelectVo.getRfidCardId());
            }

            if (deviceLibrarySelectVo.getContent() != null) {
                Class<DeviceLibrary> deviceLibraryEntity = DeviceLibrary.class;
                Field[] declaredFields = deviceLibraryEntity.getDeclaredFields();
                PredicateBuilder<DeviceLibrary> p = Specifications.or();
                for (Field field : declaredFields) {
                    if (field.getType().equals(String.class)&&field.getAnnotation(Column.class)!=null) {
                        p.like(field.getName(), "%" + deviceLibrarySelectVo.getContent() + "%");
                    }
                }
                predicateBuilder.predicate(p.build());
            }
            if (deviceLibrarySelectVo.getStartTime() != null) {
                predicateBuilder.gt("createTime", deviceLibrarySelectVo.getStartTime());
            }
            if (deviceLibrarySelectVo.getEndTime() != null) {
                predicateBuilder.lt("updateTime", deviceLibrarySelectVo.getEndTime());
            }
        }
        return predicateBuilder;
    }

    private List<String> getAllModel() {
        List<DeviceLibrary> strings = deviceLibraryDao.findAll();
        Set<String> s = new HashSet<>();
        for (DeviceLibrary d:strings) {
            s.add(d.getModel());
        }
        return new ArrayList<>(s);
    }
}
