package com.tykj.dev.device.user.subject.service;

import com.tykj.dev.device.user.base.ret.AreaVo;
import com.tykj.dev.device.user.base.ret.UnitsTrainVo;
import com.tykj.dev.device.user.subject.entity.Units;

import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName UnitsService.java
 * @Description 单位逻辑层
 * @createTime 2020年07月28日 10:05:00
 */
public interface UnitsService extends PublicService<Units>{

    Units findById(Integer unitId);

    List<Units> findListById(Integer leven);

    List<AreaVo> findListAreaUnitsVo();

    List<Units> findListlevenGreaterThanEqual(Integer leven);

    /**
     * 查询下属单位id集合
     * @param unitsId 单位id
     * @return  下属单位id集合
     */
    List<Integer> findListSubordinateId(Integer unitsId);

    List<UnitsTrainVo> findListUnitsTrainVo(Integer unitsId);

    /**
     * 根据单位ID查询上级单位id集合
     * @param unitsId 单位id
     * @return 上级单位ID集合
     */
    List<Integer> findSuperiorByunitsId(Integer unitsId);

    /**
     * 根据区域id查询上级对象
     * @param unitsId 区域id
     * @return 单位对象
     */
    Units findByAreaId(Integer unitsId);

}
