/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer;

import com.zebra.sdk.printer.discovery.DiscoveredPrinter;
import com.zebra.sdk.util.internal.StringUtilities;
import java.util.Map;

public class LinkOsInformation {
    private int major = -1;
    private int minor = -1;

    public LinkOsInformation(int n, int n2) {
        this.init(n, n2);
    }

    public LinkOsInformation(String string) {
        if (string == null || string.isEmpty()) {
            this.init(1, 0);
        } else {
            String[] stringArray = string.split("\\.");
            if (stringArray.length != 2) {
                this.init(1, 0);
            } else {
                try {
                    this.init(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
                }
                catch (Exception exception) {
                    this.init(1, 0);
                }
            }
        }
    }

    public LinkOsInformation(DiscoveredPrinter discoveredPrinter) {
        try {
            Map<String, String> map = discoveredPrinter.getDiscoveryDataMap();
            if (map.containsKey("LINK_OS_MAJOR_VER") && map.containsKey("LINK_OS_MINOR_VER")) {
                int n = StringUtilities.getIntValueForKey(map, "LINK_OS_MAJOR_VER");
                int n2 = StringUtilities.getIntValueForKey(map, "LINK_OS_MINOR_VER");
                this.init(n, n2);
            } else {
                this.init(-1, -1);
            }
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalArgumentException("The DiscoveredPrinter argument does not appear to be a Link-OS printer");
        }
    }

    private void init(int n, int n2) {
        this.major = n;
        this.minor = n2;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }
}

