package com.tykj.dev.device.allot.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.allot.service.AllotBillService;
import com.tykj.dev.device.allot.subject.domin.AllotBill;
import com.tykj.dev.device.allot.subject.vo.AllotBillDetailVo;
import com.tykj.dev.device.allot.subject.vo.AllotBillSelectVo;
import com.tykj.dev.device.library.service.DeviceLibraryService;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.task.service.TaskLogService;
import com.tykj.dev.device.task.service.TaskService;
import com.tykj.dev.device.task.subject.bto.TaskBto;
import com.tykj.dev.device.task.subject.common.BusinessEnum;
import com.tykj.dev.device.task.subject.vo.TaskLogUserVo;
import com.tykj.dev.device.user.subject.service.UserPublicService;
import com.tykj.dev.misc.utils.StringSplitUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @author dengdiyi
 */
@RestController
@Api(tags = "业务模块",description = "业务模块")
@AutoDocument
@RequestMapping("/business")
public class AllotBillSelectController {

    @Autowired
    private AllotBillService allotBillService;

    @Autowired
    private UserPublicService userService;

    @Autowired
    private DeviceLibraryService deviceLibraryService;

    @ApiOperation(value = "查询配发单", notes = "可以通过这个接口查询配发单")
    @PostMapping(value = "/archives/allot/summary")
    public ResponseEntity selectAllotBill(@RequestBody AllotBillSelectVo allotBillSelectVo) {
        Page<AllotBill> page = allotBillService.getPage(allotBillSelectVo, allotBillSelectVo.getPageable());
        return ResponseEntity.ok(page);
    }

    @ApiOperation(value = "查询配发单详情页", notes = "可以通过这个接口查询配发单")
    @GetMapping(value = "/archives/allot/detail/{id}")
    public ResponseEntity selectAllotBillDetail(@PathVariable("id") int id) {
        List<Object> list = new ArrayList<>();
        //set账单用户名称并添加
        AllotBill allotBillEntity = allotBillService.getOne(id);
        allotBillEntity.setSenderUserA(userService.getOne(allotBillEntity.getSendUseraId()).getName());
        allotBillEntity.setSenderUserB(userService.getOne(allotBillEntity.getSendUserbId()).getName());
        if (allotBillEntity.getReceiveUseraId() != null) {
            allotBillEntity.setReceiveUserA(userService.getOne(allotBillEntity.getReceiveUseraId()).getName());
        }
        if (allotBillEntity.getReceiveUserbId()!=null) {
            allotBillEntity.setReceiveUserB(userService.getOne(allotBillEntity.getReceiveUserbId()).getName());
        }
        list.add(allotBillEntity);
        List<DeviceLibrary> libraryEntities = new ArrayList<>();
        //如果接收装备详情不为空，分隔装备id并添加
        if (allotBillEntity.getAllotCheckDetail()!=null){
            for (Integer deviceId: StringSplitUtil.split(allotBillEntity.getAllotCheckDetail())) {
                libraryEntities.add(deviceLibraryService.getOne(deviceId));
            }
        }
        list.add(libraryEntities);
        return ResponseEntity.ok(list);
    }
}
