package com.tykj.dev.device.confirmcheck.entity.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for device_check_bill
 * 装备核查账单
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update device_check_bill set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@ApiModel("装备核查账单")
@Table(name = "device_check_bill", schema = "device_check_bill")
@NoArgsConstructor
public class DeviceCheckBillEntity {

    /**
     * 主键id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty(name = "主键id")
    private Integer id;
    /**
     * 检查组成员1(省A岗)id
     */

    @ApiModelProperty(value = "检查组成员1(省A岗)id")
    @Column(name = "userA_id")
    private Integer userAId;
    /**
     * 检查组成员2(省A岗)id
     */

    @ApiModelProperty(value = "检查组成员2(省A岗)id")
    @Column(name = "userB_id")
    private Integer userBId;
    /**
     * 核查状态(0:决算待审核,1:决算审核失败,2:决算中,3:决算完成)
     */

    @ApiModelProperty(value = "核查状态(0:决算待审核,1:决算审核失败,2:决算中,3:决算完成)")
    private Integer checkStatus;
    /**
     * 核查单位主键id(x作为分隔符)，例如1x2,意为单位id为1和2的装备核查
     */

    @ApiModelProperty(value = "核查单位主键id(x作为分隔符)，例如1x2,意为单位id为1和2的装备核查")
    private String checkDetail;
    /**
     * 核查标题
     */

    @ApiModelProperty(value = "核查标题")
    private String checkTitle;
    /**
     * 备注
     */

    @ApiModelProperty(value = "备注")
    private String remark;
    /**
     * 创建用户id
     */
    @CreatedBy

    @ApiModelProperty(value = "创建用户id")
    private Integer createUserId;
    /**
     * 创建时间
     */
    @CreatedDate

    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    /**
     * 更新用户id
     */
    @LastModifiedBy

    @ApiModelProperty(value = "更新用户id")
    private Integer updateUserId;
    /**
     * 更新时间
     */
    @LastModifiedDate

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
    /**
     * 删除标记(0:未删除，1:已删除)
     */

    @ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
    private Integer deleteTag = 0;

    public DeviceCheckBillEntity(Integer userAId, Integer userBId, Integer checkStatus, String checkDetail, String checkTitle, Date completeTime, String remark) {
        this.userAId = userAId;
        this.userBId = userBId;
        this.checkStatus = checkStatus;
        this.checkDetail = checkDetail;
        this.checkTitle = checkTitle;
        this.remark = remark;
    }

}
