package com.tykj.dev.device.confirmcheck.repository;

import com.tykj.dev.device.confirmcheck.entity.domain.DeviceCheckDetailEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author dengdiyi
 */
@Transactional
public interface DeviceCheckDetailDao extends JpaRepository<DeviceCheckDetailEntity, Integer>, JpaSpecificationExecutor<DeviceCheckDetailEntity> {

    /**
     * 根据id更新checkDetail
     *
     * @param id          detail id
     * @param checkDetail 要更新的检查结果
     */
    @Modifying
    @Query("update DeviceCheckDetailEntity o set o.checkDetail=?2,o.checkResult = ?3,o.userAId =?4,o.userBId=?5,o.checkedCount=?6 where o.id=?1")
    void updateCheckDetail(Integer id, String checkDetail, String checkResult, int userAId, int userBId, long checkedCount);

    @Modifying
    @Query("update DeviceCheckDetailEntity o set o.checkStatus=?2 where o.id=?1")
    int updateCheckStatus(int id, int checkStatus);

    /**
     * 更新 checkUserAId 与 checkUserBId
     *
     * @param id           detailId
     * @param checkUserAId 核查组成员A
     * @param checkUserBId 核查组成员B
     */
    @Modifying
    @Query("update DeviceCheckDetailEntity o set o.checkUserAId =?2,o.checkUserBId=?3 where o.id =?1")
    void updateCheckUser(int id, int checkUserAId, int checkUserBId);
}
