package com.tykj.dev.device.file.service.Impl;

import com.tykj.dev.device.file.entity.WrodParameter;
import com.tykj.dev.device.file.service.UseReportFIleService;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.springframework.beans.factory.annotation.Value;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName UseReportFIleServiceImpl.java
 * @Description TODO
 * @createTime 2020年09月15日 19:33:00
 */
public class UseReportFIleServiceImpl implements UseReportFIleService {
    @Value("${file.path}")
    public String url;
    @Value("${preview.path}")
    public String preview;
    @Override
    public String findToFileService(WrodParameter wrodParameter) throws IOException {
        XWPFDocument doc = new XWPFDocument();// 创建Word文件
        XWPFParagraph p = doc.createParagraph();// 新建一个段落
//        p.setAlignment(ParagraphAlignment.CENTER);// 设置段落的对齐方式
//        p.setBorderBottom(Borders.DOUBLE);//设置下边框
//        p.setBorderTop(Borders.DOUBLE);//设置上边框
//        p.setBorderRight(Borders.DOUBLE);//设置右边框
//        p.setBorderLeft(Borders.DOUBLE);//设置左边框
        p.setAlignment(ParagraphAlignment.CENTER);
        XWPFRun title1 = p.createRun();//创建段落文本
        title1.setText(wrodParameter.getTitle1());
        title1.setBold(true);//设置为粗体
//        r.setColor("FF0000");

        p = doc.createParagraph();
        p.setAlignment(ParagraphAlignment.CENTER);// 新建一个段落
        XWPFRun title2 = p.createRun();
        title2.setText(wrodParameter.getTitle2());


        //总的统计内容
        p = doc.createParagraph();
        p.setIndentationFirstLine(100);
        p.setSpacingBeforeLines(50);
        XWPFRun title3 = p.createRun();
        title3.setText(wrodParameter.getTotal());

        //自查统计内容
        p = doc.createParagraph();
        p.setIndentationFirstLine(100);
        p.setSpacingBeforeLines(50);
        XWPFRun title4 = p.createRun();
        title4.setText(wrodParameter.getComfirmCheck());

        //核查统计内容
        p = doc.createParagraph();
        p.setIndentationFirstLine(100);
        p.setSpacingBeforeLines(50);
        p.setSpacingAfterLines(150);
        XWPFRun title5 = p.createRun();
        title5.setText(wrodParameter.getSelfCheck());

        //单位
        p = doc.createParagraph();
        XWPFRun title6 = p.createRun();
        title6.setText("专管员签字：                                                                                                  xx单位");

        //时间
        p = doc.createParagraph();
        p.setAlignment(ParagraphAlignment.RIGHT);
        XWPFRun title7 = p.createRun();
        title7.setText("2020年12月1日");


        FileOutputStream out = new FileOutputStream(url+wrodParameter.getTitle1()+".doc");
        doc.write(out);
        out.close();

        return preview+wrodParameter.getTitle1()+".doc";
    }
}
