package com.tykj.dev.device.matching.service;

import com.tykj.dev.device.matching.subject.domin.MatchingDeviceLibrary;
import com.tykj.dev.device.matching.subject.vo.MatchingDeviceSelectVo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @author dengdiyi
 */
public interface MatchingDeviceLibraryService {

    /**
     * @param matchingDeviceLibraryEntity
     * 添加配套设备
     */
    MatchingDeviceLibrary addEntity(MatchingDeviceLibrary matchingDeviceLibraryEntity);

    /**
     * @param id
     * 通过id查询配套设备
     */
    MatchingDeviceLibrary getOne(Integer id);

    /**
     * @param matchingDeviceLibraryEntity
     * 更新配套设备信息
     */
    MatchingDeviceLibrary update(MatchingDeviceLibrary matchingDeviceLibraryEntity);

    /**
     * @param id
     * 删除配套设备
     */
    void delete(Integer id);

    /**
     * @param matchingDeviceSelectVo 配套设备查询vo
     * @param pageable
     * 配套设备分页查询
     */
    Page<MatchingDeviceLibrary> getPage(MatchingDeviceSelectVo matchingDeviceSelectVo, Pageable pageable);

    /**
     * @return 所有类型
     */
    List<String> getAllModel();

    /**
     * @return 所有名称
     */
    List<String> getAllName();
}
