package com.tykj.dev.device.repair.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.library.service.DeviceLibraryService;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.repair.repository.RepairSendBillDao;
import com.tykj.dev.device.repair.service.RepairBillService;
import com.tykj.dev.device.repair.service.RepairDetailService;
import com.tykj.dev.device.repair.subject.domin.RepairBill;
import com.tykj.dev.device.repair.subject.domin.RepairDetail;
import com.tykj.dev.device.repair.subject.domin.RepairSendBill;
import com.tykj.dev.device.repair.subject.vo.RepairBillSelectVo;
import com.tykj.dev.device.task.subject.common.RepairStatusEnum;
import com.tykj.dev.misc.utils.ResultUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @author dengdiyi
 */
@RestController
@RequestMapping(value = "/business")
@AutoDocument
@Api(tags = "业务模块",description = "业务模块")
public class RepairBillSelectController {

    @Autowired
    private RepairBillService repairBillService;

    @Autowired
    private RepairSendBillDao repairSendBillDao;

    @Autowired
    private DeviceLibraryService deviceLibraryService;

    @Autowired
    private RepairDetailService repairDetailService;

    @ApiOperation(value = "查询维修单", notes = "可以通过这个接口查询维修单")
    @PostMapping(value = "/archives/repair/summary")
    public ResponseEntity selectRepairBill(@RequestBody RepairBillSelectVo repairBillSelectVo) {
        return ResultUtil.success(repairBillService.getPage(repairBillSelectVo, repairBillSelectVo.getPageable()));
    }

    @ApiOperation(value = "查询维修单详情", notes = "可以通过这个接口查询维修单详情")
    @GetMapping(value = "/archives/repair/detail/{id}")
    public ResponseEntity selectRepairBillDetail(@PathVariable("id") int id){
        List<Object> list = new ArrayList<>();
        //获取维修单
        RepairBill repairBill = repairBillService.getOne(id);
        list.add(repairBill);
        //获取装备列表
        RepairSendBill repairSendBill = repairSendBillDao.findByDeviceRepairBillId(repairBill.getId());
        list.add(repairSendBill);
        List<DeviceLibrary> deviceLibraries = new ArrayList<>();
        if (repairSendBill.getRepairReciveCheckDetail()!=null) {
            String[] strings1 = repairSendBill.getRepairReciveCheckDetail().split("x");
            for (String s : strings1) {
                if (s.length() >= 2 && "1".equals(s.substring(s.length() - 1))) {
                    Integer deviceId = Integer.parseInt(s.substring(0, s.length() - 1));
                    Integer checkResult = Integer.parseInt(s.substring(s.length() - 1));
                    DeviceLibrary deviceLibraryEntity = deviceLibraryService.getOne(deviceId);
                    deviceLibraryEntity.setCheckResult(checkResult);
                    deviceLibraries.add(deviceLibraryEntity);
                }
            }
        }
        //获取维修详情
        List<RepairDetail> repairDetails = getRepairDetail(repairBill.getId());
        //设置装备备注
        deviceLibraries.forEach(deviceLibrary -> {
            for (RepairDetail r:repairDetails) {
                if (r.getDeviceId().equals(deviceLibrary.getId())){
                    deviceLibrary.setRemark(r.getRemark());
                }
            }
        });
        list.add(deviceLibraries);
        return ResponseEntity.ok(list);
    }

    /**
     * @param repairBillId 维修单id
     * @return 维修详情列表
     * 根据维修单Id查询维修详情，排序返回
     */
    private List<RepairDetail> getRepairDetail(int repairBillId){
        List<RepairDetail> repairDetails = repairDetailService.findByBillId(repairBillId);
        List<RepairDetail> orderList = new ArrayList<>();
        repairDetails.forEach(repairDetail -> {
            if (!repairDetail.getRepairStatus().equals(RepairStatusEnum.CHANGE_NEW.id)) {
                orderList.add(repairDetail);
                if (repairDetail.getRepairStatus().equals(RepairStatusEnum.SCRAPPED.id)) {
                    if (repairDetail.getNewDeviceDetailId()!=null&&repairDetail.getNewDeviceDetailId() > 0) {
                        orderList.add(repairDetailService.getOne(repairDetail.getNewDeviceDetailId()));
                    }
                }
            }
        });
        return orderList;
    }
}
