package com.tykj.dev.device.train.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.tykj.dev.device.train.entity.vo.*;
import com.tykj.dev.misc.base.BeanHelper;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.util.Date;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName TrainTheme.java
 * @Description 新增培训对象
 * @createTime 2020年08月11日 21:35:00
 */
@ApiModel("新增培训对象")
@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
public class TrainTheme {
    /**
     * 培训id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty(value = "培训id")
    private Integer trainId;

    /**
     * 培训主题
     */
    @ApiModelProperty(value = "培训主题")
    private String name;

    /**
     * 报名截止时间
     */
    @ApiModelProperty(value = "报名截止时间")
    private Date trainTime;

    /**
     *  发起人 originator
     */
    @ApiModelProperty(value = "发起人")
    private String  originatorName;

    /**
     *  发起人 originator
     */
    @ApiModelProperty(value = "发起人id")
    private Integer  originatorId;

    /**
     * 主办单位
     */
    @ApiModelProperty(value = "主办单位名称")
    private String unitsName;

    /**
     * 主办单位
     */
    @ApiModelProperty(value = "主办单位")
    private Integer unitsId;

    /**
     * 培训开始时间
     */
    @ApiModelProperty(value = "培训开始时间")
    private Date startTime;
    /**
     * 培训结束时间
     */
    @ApiModelProperty(value = "培训结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date endTime;

    /**
     * 培训地点
     */
    @ApiModelProperty(value = "培训地点")
    private String trainLocation;

    /**
     * 主讲人
     */
    @ApiModelProperty(value = "主讲人")
    private String  speakerUserId;

    /**
     * 培训资料名称
     */
    @ApiModelProperty(value = "培训资料")
    private String trainDataName;

    /**
     * 培训url
     */
    @ApiModelProperty(value = "培训资料")
    private String trainDataUrl;


    /**
     * 培训简介
     */
    @ApiModelProperty(value = "trainSynopsis")
    private String trainSynopsis;

    /**
     * 参会人员（必须参会）
     */
    @ApiModelProperty(value = "参会人员id 多个使用人员id+x+id+x")
    private String joinUserId;

    /**
     * 不必须参会人员
     */
    @ApiModelProperty(value = "参会人员id 多个使用人员id+x+id+x")
    private String noJoinUserId;

    /**
     * 报名人员
     */
    @ApiModelProperty(value = "参会人员id 多个使用人员id+x+id+x")
    private String signUp;

    /**
     * 培训结果
     */
    private String trainingResults;

    /**
     * 培训状态 1报名中  2待培训  3培训中
     */
    @ApiModelProperty(value = "培训状态")
    private Integer trainStatus;

    /**
     * 发证状态
     */
    @ApiModelProperty(value = "发证状态")
    private Integer isCertificate;

    /**
     * 及格
     */
    @ApiModelProperty(value = "发证状态")
    private Integer pass;

    /**
     * 优秀
     */
    @ApiModelProperty(value = "发证状态")
    private Integer good;



    public ByTrainingPeople toByTrainingPeople(){
        ModelMapper mapper= BeanHelper.getUserMapper();
        return mapper.map(this, ByTrainingPeople.class);
    }

    public TrainThemeVo toTrainThemeVo(){
        ModelMapper mapper= BeanHelper.getUserMapper();
        return mapper.map(this,TrainThemeVo.class);
    }

    public TrainRegistrationVo toTrainRegistrationVo(){
        ModelMapper mapper= BeanHelper.getUserMapper();
        return mapper.map(this,TrainRegistrationVo.class);
    }

    public TrainTrainingVo toTrainTrainingVo(){
        ModelMapper mapper= BeanHelper.getUserMapper();
        return mapper.map(this, TrainTrainingVo.class);
    }

    public TrainAuditVo toTrainAuditVo(){
        ModelMapper mapper= BeanHelper.getUserMapper();
        return mapper.map(this,TrainAuditVo.class);
    }



}
