package com.tykj.dev.device.train.task;

import com.tykj.dev.device.task.service.TaskService;
import com.tykj.dev.device.task.subject.common.StatusEnum;
import com.tykj.dev.device.train.service.TrainTaskService;
import com.tykj.dev.device.train.service.TrainThemeService;
import com.tykj.dev.device.user.subject.dao.UnitsDao;
import com.tykj.dev.device.user.subject.service.MgrcertService;
import com.tykj.dev.device.user.subject.service.UserService;
import com.tykj.dev.socket.MyWebSocket;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName TrainTask.java
 * @Description 培训定时任务 主要是 判断报名截止以及培训开始、培训结束
 * @createTime 2020年08月17日 23:20:00
 */
@Service
public class TrainTask {
    @Autowired
    TrainThemeService trainThemeService;
    @Autowired
    TaskService taskService;
    @Autowired
    MgrcertService mgrcertService;
    @Autowired
    TrainTaskService trainTaskService;
    @Autowired
    UnitsDao unitsDao;
    @Autowired
    UserService userService;
    @Autowired
    MyWebSocket myWebSocket;

    @Scheduled(cron ="0 0/1 * * * ?")
    private void signUpDeadline(){
     trainThemeService.findAllStatus(1).forEach(
             trainTheme -> {
                 long time=new Date().getTime();
                 if (trainTheme.getTrainTime().getTime()>time){

                     //查询所有必须报名而没有报名的task 状态直接转为待培训
                     trainTaskService.selectBillidAndBillType(trainTheme.getTrainId(),13,StatusEnum.TRAIN1001.id).forEach(
                             taskBto -> taskService.moveToSpecial(taskBto,StatusEnum.TRAIN1003,-1)
                     );

                     trainTaskService.selectBillidAndBillType(trainTheme.getTrainId(),13,StatusEnum.TRAIN1002.id).forEach(
                             taskBto -> taskService.moveToEnd(taskBto)
                     );

                     trainTaskService.selectBillidAndBillType(trainTheme.getTrainId(),13, StatusEnum.TRAIN1000.id).forEach(
                             taskBto -> taskService.moveToSpecial(taskBto,StatusEnum.TRAIN1010)
                     );
                     trainTheme.setTrainStatus(StatusEnum.TRAIN1010.id);
                     trainThemeService.save(trainTheme);
                     myWebSocket.sendMessage1();
                 }
             }
     );
    }
    @Scheduled(cron ="0 0/1 * * * ?")
    private void trainingStarted(){
        trainThemeService.findAllStatus(2).forEach(
                trainTheme -> {
                    //5 培训中
                    trainTaskService.selectBillidAndBillType(trainTheme.getTrainId(),13,StatusEnum.TRAIN1010.id).forEach(
                            taskBto -> taskService.moveToSpecial(taskBto,StatusEnum.TRAIN1004)
                    );
                    trainTheme.setTrainStatus(8);
                    trainThemeService.save(trainTheme);
                });

    }
    @Scheduled(cron ="0 0/1 * * * ?")
    private void trainingEnd(){
        trainThemeService.findAllStatus(3).forEach(
                trainTheme -> {
                    trainTaskService.selectBillidAndBillType(trainTheme.getTrainId(),13,StatusEnum.TRAIN1004.id).forEach(
                            taskBto -> taskService.moveToSpecial(taskBto,StatusEnum.TRAIN1008)
                    );
                    //5 录入成绩
                    trainTheme.setTrainStatus(30);
                    trainThemeService.save(trainTheme);
                });
    }

    @Scheduled(cron ="10 * * * * ?")
    private void trainingEnd1(){ System.out.println("启动websocket--");
      myWebSocket.sendMessage1();
    }
}
