package com.tykj.dev.device.user.subject.service.impl;

import com.tykj.dev.device.user.base.ret.AreaInstitutions;
import com.tykj.dev.device.user.base.ret.AreaVo;
import com.tykj.dev.device.user.base.ret.UnitsVo;
import com.tykj.dev.device.user.subject.dao.AreaDao;
import com.tykj.dev.device.user.subject.dao.UnitsDao;
import com.tykj.dev.device.user.subject.entity.Area;
import com.tykj.dev.device.user.subject.entity.Units;
import com.tykj.dev.device.user.subject.service.AreaService;
import com.tykj.dev.device.user.subject.service.UnitsService;
import com.tykj.dev.misc.exception.ApiException;
import com.tykj.dev.misc.utils.ResultUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName AreaServiceImpl.java
 * @Description TODO
 * @createTime 2020年09月04日 14:39:00
 */
@Service
@Slf4j
public class AreaServiceImpl implements AreaService {
    @Autowired
    AreaDao areaDao;

   @Autowired
    UnitsService unitsService;

    @Override
    public List<AreaInstitutions> findAllUserUnitsIdAreaList(Integer areaId) {
        Optional<Area> areaOptional = areaDao.findById(areaId);
        log.info("区域id：{}",areaId);
        List<AreaInstitutions> areaInstitutions=new ArrayList<>();
        if (areaOptional.isPresent()){
//           return subordinateArea(areaInstitutions,areaOptional.get());
            return null;
        } else {
            throw new ApiException(ResultUtil.failed("区域id不能为空"));
        }
    }

    @Override
    public List<AreaVo> findAll(Integer areaId) {
        List<AreaVo> areaVos=new ArrayList<>();
        Optional<Area> areaOptional = areaDao.findById(areaId);
        if (areaOptional.isPresent()){
            Area area = areaOptional.get();
            List<Area> list= areaDao.findAllByFatherId(area.getId());
            if (list.size()!=0){
                if (area.getType() <= 2){
                    AreaVo areaVo= area.toVo();
                    areaVo.setName(area.getName()+"本级");
                    areaVo.setUnits(unitsService.findListVoAreaId(areaId));
                    areaVos.add(areaVo);
                }
                for (Area area1:list){
                    AreaVo areaVo= area1.toVo();
//                    areaVo.setFrontEnd(i++);
                    List<UnitsVo> unitsList = new ArrayList<>(unitsService.findListVoAreaId(area1.getId()));
                    subordinateAllUnits(unitsList,area1);
//                    for (UnitsVo unitsVo:unitsList){
//                        unitsVo.setFrontEnd(i++);
//                  }
                    areaVo.setUnits(unitsList);
                    areaVos.add(areaVo);
                }
            }else {
                AreaVo areaVo= area.toVo();
                areaVo.setUnits(unitsService.findListVoAreaId(areaId));
                areaVos.add(areaVo);
            }
            return areaVos;
        } else {
            throw new ApiException(ResultUtil.failed("区域id不能为空"));
        }

    }

    private List<UnitsVo> subordinateAllUnits(List<UnitsVo> units,Area area){
        List<Area> list= areaDao.findAllByFatherId(area.getId());
        if (list.size()==0){
            return units;
        }
        list.forEach(
                area1 -> {
                    List<UnitsVo> unitsVos;
                    unitsVos=unitsService.findListVoAreaId(area1.getId());
                    units.addAll(unitsVos);
                    subordinateAllUnits(units,area1);
                }
        );
       return units;
    }

//    private List<AreaInstitutions> subordinateArea(List<AreaInstitutions> areaInstitutions ,Area area){
//      List<Area> list= areaDao.findAllByFatherId(area.getId());
//        if (list==null || list.size()==0){
//            areaInstitutions.add(new AreaInstitutions(area.getId(), area.getName(), areaInstitutions, unitsDao.findAllByAreaId(area.getId()).stream().map(Units::toVo).collect(Collectors.toList())));
//            return areaInstitutions;
//        }
//        if (area.getType() < 2) {
//            areaInstitutions.add(new AreaInstitutions(area.getId(), area.getName(), areaInstitutions, unitsDao.findAllByAreaId(area.getId()).stream().map(Units::toVo).collect(Collectors.toList())));
//        }
//
//        list.forEach(
//              area1 -> {
//                  List<AreaInstitutions> areaInstitutions1=new ArrayList<>();
//                  subordinateArea(areaInstitutions1,area1);
//                  if (area.getType()==2) {
//                      areaInstitutions1.add(new AreaInstitutions(area.getId(), area.getName(), areaInstitutions, unitsDao.findAllByAreaId(area.getId()).stream().map(Units::toVo).collect(Collectors.toList())));
//                  }
//                  areaInstitutions.add(new AreaInstitutions(area1.getId(),area1.getName(),areaInstitutions1,unitsDao.findAllByAreaId(area1.getId()).stream().map(Units::toVo).collect(Collectors.toList())));
//              }
//      );
//        return areaInstitutions;
//    }

    @Override
    public Area save(Area area) {
        return areaDao.save(area);
    }

    @Override
    public boolean delete(Integer id) {

        return false;
    }

    @Override
    public List<Area> findAll() {
        return areaDao.findAll();
    }

    @Override
    public Area update(Area area) {
        return areaDao.save(area);
    }
}
