package com.tykj.dev.device.user.subject.service.impl;

import com.tykj.dev.device.user.base.ret.PermissionsType;
import com.tykj.dev.device.user.subject.dao.PermissionsDao;
import com.tykj.dev.device.user.subject.entity.Permissions;
import com.tykj.dev.device.user.subject.service.PermissionsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName PermissionsServiceImpl.java
 * @Description 权限逻辑层
 * @createTime 2020年07月27日 15:06:00
 */
@Service
public class PermissionsServiceImpl implements PermissionsService {
    @Autowired
    PermissionsDao permissionsDao;
    @Override
    public Permissions save(Permissions permissions) {
        return permissionsDao.save(permissions);
    }

    @Override
    public boolean delete(Integer id) {
        permissionsDao.deleteById(id);
        return true;
    }

    @Override
    public List<Permissions> findAll() {
        return permissionsDao.findAll();
    }

    @Override
    public Permissions update(Permissions permissions) {
        return permissionsDao.save(permissions);
    }

    @Override
    public List<Permissions> findAllByPerissionsIds(List<Integer> ids) {
        return permissionsDao.findAllById(ids);
    }

    @Override
    public List<PermissionsType> findAllOrberPermissionsType() {

        List<PermissionsType> list=new ArrayList<>();
        Map<Integer,List<Permissions>> map=new HashMap<>();
        permissionsDao.findAll().forEach(permissions -> {
        if (map.containsKey(permissions.getType())){
          List<Permissions> permissions1=  map.get(permissions.getType());
          permissions1.add(permissions);
            map.put(permissions.getType(),permissions1);
        }else {
            List<Permissions> list1=new ArrayList<>();
            list1.add(permissions);
            map.put(permissions.getType(),list1);
        }
        });
        for (Integer key:map.keySet()){
            list.add(new PermissionsType(key,map.get(key)));
        }
        return list;
    }
}
