package com.tykj.dev.device.user.subject.service.impl;

import com.tykj.dev.device.user.base.ret.AreaVo;
import com.tykj.dev.device.user.base.ret.UnitsTrainVo;
import com.tykj.dev.device.user.base.ret.UnitsVo;
import com.tykj.dev.device.user.subject.dao.AreaDao;
import com.tykj.dev.device.user.subject.dao.UnitsDao;
import com.tykj.dev.device.user.subject.entity.Area;
import com.tykj.dev.device.user.subject.entity.Units;
import com.tykj.dev.device.user.subject.service.UnitsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName UnitsServiceImpl.java
 * @Description TODO
 * @createTime 2020年07月28日 10:14:00
 */
@Service
public class UnitsServiceImpl implements UnitsService {
    @Autowired
    UnitsDao unitsDao;
    @Autowired
    AreaDao areaDao;
    @Override
    public Units findById(Integer unitId) {
        Optional<Units> unit = unitsDao.findById(unitId);
        return unit.orElse(null);
    }

    @Override
    public List<Units> findListById(Integer leven) {
        return unitsDao.findAllByLevel(leven);
    }

    @Override
    public List<AreaVo> findListAreaUnitsVo() {
        List<AreaVo> areaVos=new ArrayList<>();

        List<Area> list = areaDao.findAll();
        int i=0;

        for (Area area:list){
            AreaVo areaVo= area.toVo();
            areaVo.setFrontEnd(i++);
            List<UnitsVo> unitsList= unitsDao.findAllByAreaId(area.getId()).stream().map(Units::toVo).collect(Collectors.toList());

            for (UnitsVo unitsVo:unitsList){
                 unitsVo.setFrontEnd(i++);
            }
            areaVo.setUnits(unitsList);
            areaVos.add(areaVo);
        }

        return areaVos;
    }

    @Override
    public List<Units> findListlevenGreaterThanEqual(Integer leven) {
        return unitsDao.findAllByLevelGreaterThanEqual(leven);
    }

    @Override
    public List<Integer> findListSubordinateId(Integer unitsId) {
      Integer areaId = unitsDao.findById(unitsId).get().getAreaId();
      List<Integer> areaIds=areaDao.findAllByFatherId(areaId).stream().map(Area::getId).collect(Collectors.toList());
        return unitsDao.findAllByAreaIdIn(areaIds).stream().map(Units::getUnitId).collect(Collectors.toList());
    }

    @Override
    public List<UnitsVo> findListVoSubordinateAreaId(Integer areaId) {
        List<UnitsVo> unitsVos=new ArrayList<>();
        List<Integer> areaIds=areaDao.findAllByFatherId(areaId).stream().map(Area::getId).collect(Collectors.toList());
        if (areaIds.size() != 0) {
            unitsVos= unitsDao.findAllByAreaIdIn(areaIds).stream().map(Units::toVo).collect(Collectors.toList());
        }
        return unitsVos;
    }

    @Override
    public List<UnitsVo> findListVoAreaId(Integer areaId) {
        return unitsDao.findAllByAreaId(areaId).stream().map(Units::toVo).collect(Collectors.toList());
    }

    @Override
    public List<UnitsTrainVo> findListUnitsTrainVo(Integer unitsId) {
        Integer areaId = unitsDao.findById(unitsId).get().getAreaId();
        List<Integer> areaIds=areaDao.findAllByFatherId(areaId).stream().map(Area::getId).collect(Collectors.toList());
        return unitsDao.findAllByAreaIdIn(areaIds).stream().map(Units::toUnitsTrainVo).collect(Collectors.toList());
    }

    @Override
    public List<Integer> findSuperiorByunitsId(Integer unitsId) {
        Area area= areaDao.findById(this.findById(unitsId).getAreaId()).get();
        return unitsDao.findAllByAreaId(area.getFatherId()).stream().map(Units::getUnitId).collect(Collectors.toList());
    }

    @Override
    public Units findByAreaId(Integer unitsId) {

        return  unitsDao.findAllByAreaId(areaDao.findById(findById(unitsId).getAreaId()).get().getFatherId() ).get(0);

    }

    @Override
    public Units save(Units units) {
        return unitsDao.save(units);
    }

    @Override
    public boolean delete(Integer id) {
        unitsDao.deleteById(id);
        return true;
    }

    @Override
    public List<Units> findAll() {
        return unitsDao.findAll();
    }

    @Override
    public Units update(Units units) {
        return unitsDao.save(units);
    }
}
