package com.tykj.dev.device.usereport.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.file.entity.WrodParameter;
import com.tykj.dev.device.usereport.service.DeviceUseReportService;
import com.tykj.dev.device.usereport.subject.domin.DeviceUseReport;
import com.tykj.dev.device.usereport.subject.vo.DeviceUseReportCreateVo;
import com.tykj.dev.device.usereport.subject.vo.DeviceUseReportDetailVo;
import com.tykj.dev.device.usereport.subject.vo.DeviceUseReportSelectVo;
import com.tykj.dev.misc.utils.ResultUtil;
import com.tykj.dev.misc.utils.StringSplitUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Calendar;
import java.util.List;
import java.util.Objects;

/**
 * @author dengdiyi
 */
@RestController
@RequestMapping(value = "/check/report")
@AutoDocument
@Api(tags = "装备使用报告模块",description = "装备使用报告接口")
public class DeviceUseReportController {

    @Autowired
    private DeviceUseReportService deviceUseReportService;

    @ApiOperation(value = "模糊查询装备使用报告分页", notes = "可以通过这个接口模糊查询装备使用报告分页")
    @PostMapping("/summary")
    public ResponseEntity selectDeviceUseReport(@RequestBody DeviceUseReportSelectVo deviceUseReportSelectVo) {
        Page<DeviceUseReport> deviceUseReportEntities = deviceUseReportService.getPage(deviceUseReportSelectVo, deviceUseReportSelectVo.getPageable());
        return ResultUtil.success(deviceUseReportEntities);
    }

    @ApiOperation(value = "生成装备使用报告", notes = "可以通过这个接口生成装备使用报告")
    @PostMapping("/create")
    public ResponseEntity createDeviceUseReport(@RequestBody DeviceUseReportCreateVo deviceUseReportCreateVo) {
        return ResultUtil.success(deviceUseReportService.createReport(deviceUseReportCreateVo));
    }

    @ApiOperation(value = "查询装备使用报告详情页", notes = "查询装备使用报告详情页")
    @GetMapping("/detail/{id}")
    public ResponseEntity selectDetail(@PathVariable("id") int id) {
        DeviceUseReport d = deviceUseReportService.getOne(id);
        DeviceUseReportDetailVo deviceUseReportDetailVo = new DeviceUseReportDetailVo();
        BeanUtils.copyProperties(d, deviceUseReportDetailVo);
        //分解数量详情组合字段
        List<Integer> list = StringSplitUtil.userIdSplit(d.getReportDetail());
        if (list.size() > 7) {
            deviceUseReportDetailVo.setDeviceNumber(list.get(0));
            deviceUseReportDetailVo.setInLibraryNum(list.get(1));
            deviceUseReportDetailVo.setRepairNum(list.get(2));
            deviceUseReportDetailVo.setAllotNum(list.get(3));
            deviceUseReportDetailVo.setSendBackNum(list.get(4));
            deviceUseReportDetailVo.setDestoryNum(list.get(5));
            deviceUseReportDetailVo.setPackingNum(list.get(6));
            deviceUseReportDetailVo.setRetiredNum(list.get(7));
        }
        return ResultUtil.success(deviceUseReportDetailVo);
    }

    @ApiOperation(value = "装备使用报告下载", notes = "装备使用报告下载")
    @GetMapping("/download/{id}")
    public ResponseEntity getDownloadUrl(@PathVariable("id") int id){
        DeviceUseReportDetailVo deviceUseReportDetailVo = (DeviceUseReportDetailVo)selectDetail(id).getBody();
        WrodParameter wrodParameter = new WrodParameter();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(Objects.requireNonNull(deviceUseReportDetailVo).getCreateTime());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(calendar.get(Calendar.YEAR)).append("年").append(calendar.get(Calendar.MONTH)).append("月").append(calendar.get(Calendar.DAY_OF_MONTH)).append("日");
        wrodParameter.setTime(stringBuffer.toString());
        wrodParameter.setUnitsName(deviceUseReportDetailVo.getUnit());
        wrodParameter.setTotal(deviceUseReportDetailVo.getDeviceNumber().toString());
        return null;
    }
}
