/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.discovery;

import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.internal.NativeUsbAdapter;
import com.zebra.sdk.comm.internal.ZDriverAdapter;
import com.zebra.sdk.printer.discovery.DiscoveredPrinter;
import com.zebra.sdk.printer.discovery.DiscoveredPrinterDriver;
import com.zebra.sdk.printer.discovery.DiscoveredPrinterFilter;
import com.zebra.sdk.printer.discovery.DiscoveredUsbPrinter;
import com.zebra.sdk.printer.discovery.internal.UsbDiscoverWindows;
import com.zebra.sdk.printer.discovery.internal.UsbDiscovererLibUsb;
import com.zebra.sdk.printer.discovery.internal.UsbDiscoveryI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class UsbDiscoverer {
    private static final String driverNameTag = "&&&DRIVERNAME:";
    private static final String portNameTag = "&&&PORTNAMES:";
    private static final String printerNameTag = "&&&PRINTERNAME:";
    private static final int ZEBRA_USB_VID = 2655;
    private static final List<String> SUPPORTED_MFG_NAMES = Arrays.asList("zebra", "zebra technologies", "zebra card printer", "zebra digital card printer");

    public static DiscoveredPrinterDriver[] getZebraDriverPrinters() throws ConnectionException {
        String string = System.getProperty("os.name").toLowerCase();
        if (!string.contains("windows")) {
            throw new ConnectionException("Invalid OS");
        }
        if (!NativeUsbAdapter.isDriverLoaded) {
            throw new ConnectionException("The native code dll is not loaded.");
        }
        String[] stringArray = (String[])ZDriverAdapter.GetZebraPrintersWithDriverAndPortNames();
        ArrayList<DiscoveredPrinterDriver> arrayList = new ArrayList<DiscoveredPrinterDriver>();
        for (String string2 : stringArray) {
            DiscoveredPrinterDriver discoveredPrinterDriver = UsbDiscoverer.createDiscoveredPrinterDriver(string2);
            if (!UsbDiscoverer.printerIsOnUsbPort(discoveredPrinterDriver)) continue;
            arrayList.add(discoveredPrinterDriver);
        }
        Object[] objectArray = new DiscoveredPrinterDriver[arrayList.size()];
        arrayList.toArray(objectArray);
        return objectArray;
    }

    private static boolean printerIsOnUsbPort(DiscoveredPrinterDriver discoveredPrinterDriver) {
        return discoveredPrinterDriver.portNames[0].toLowerCase().contains("usb");
    }

    private static DiscoveredPrinterDriver createDiscoveredPrinterDriver(String string) {
        int n = string.indexOf(driverNameTag) + driverNameTag.length();
        int n2 = string.indexOf(portNameTag);
        int n3 = n2 + portNameTag.length();
        int n4 = string.indexOf(printerNameTag);
        int n5 = n4 + printerNameTag.length();
        String string2 = string.substring(n, n2);
        String string3 = string.substring(n3, n4);
        String string4 = string.substring(n5);
        String[] stringArray = string3.split(",");
        return new DiscoveredPrinterDriver(string4, string2, stringArray);
    }

    public static DiscoveredUsbPrinter[] getZebraUsbPrinters() throws ConnectionException {
        UsbDiscoverer usbDiscoverer = null;
        String string = System.getProperty("os.name").toLowerCase();
        usbDiscoverer = string.contains("windows") ? new UsbDiscoverWindows() : new UsbDiscovererLibUsb();
        return UsbDiscoverer.storePrintersIntoArray(usbDiscoverer, null);
    }

    public static DiscoveredUsbPrinter[] getZebraUsbPrinters(DiscoveredPrinterFilter discoveredPrinterFilter) throws ConnectionException {
        UsbDiscoverer usbDiscoverer = null;
        String string = System.getProperty("os.name").toLowerCase();
        usbDiscoverer = string.contains("windows") ? new UsbDiscoverWindows() : new UsbDiscovererLibUsb();
        return UsbDiscoverer.storePrintersIntoArray(usbDiscoverer, discoveredPrinterFilter);
    }

    private static DiscoveredUsbPrinter[] storePrintersIntoArray(UsbDiscoveryI usbDiscoveryI, DiscoveredPrinterFilter discoveredPrinterFilter) throws ConnectionException {
        List<DiscoveredUsbPrinter> list = null;
        list = usbDiscoveryI.getPrinters(discoveredPrinterFilter);
        DiscoveredUsbPrinter[] discoveredUsbPrinterArray = null;
        if (list != null) {
            discoveredUsbPrinterArray = new DiscoveredUsbPrinter[list.size()];
            list.toArray(discoveredUsbPrinterArray);
        }
        return discoveredUsbPrinterArray;
    }

    protected void loadZebraPrintersIntoArray(ArrayList<DiscoveredUsbPrinter> arrayList, DiscoveredUsbPrinter discoveredUsbPrinter, DiscoveredPrinterFilter discoveredPrinterFilter) {
        String string;
        Map<String, String> map;
        if (discoveredPrinterFilter == null) {
            discoveredPrinterFilter = new DeviceFilterImpl();
        }
        if ((map = discoveredUsbPrinter.getDiscoveryDataMap()).containsKey("vid")) {
            String string2 = map.get("vid");
            if (string2 != null && !string2.isEmpty() && Integer.parseInt(string2, 16) == 2655 && discoveredPrinterFilter != null && discoveredPrinterFilter.shouldAddPrinter(discoveredUsbPrinter)) {
                arrayList.add(discoveredUsbPrinter);
            }
        } else if (map.containsKey("MFG") && SUPPORTED_MFG_NAMES.contains(string = map.get("MFG").trim().toLowerCase()) && discoveredPrinterFilter != null && discoveredPrinterFilter.shouldAddPrinter(discoveredUsbPrinter)) {
            arrayList.add(discoveredUsbPrinter);
        }
    }

    private class DeviceFilterImpl
    implements DiscoveredPrinterFilter {
        private DeviceFilterImpl() {
        }

        @Override
        public boolean shouldAddPrinter(DiscoveredPrinter discoveredPrinter) {
            return true;
        }
    }
}

