/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.settings.internal;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.util.internal.JacksonObjectMapperFactory;
import com.zebra.sdk.util.internal.StringUtilities;
import java.util.List;
import java.util.Map;

public class JsonHelper {
    public static byte[] buildQuery(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder("{}{");
        for (String string : list) {
            stringBuilder.append("\"");
            stringBuilder.append(string);
            stringBuilder.append("\":null,");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append("}");
        return stringBuilder.toString().getBytes();
    }

    public static Map<String, String> parseGetResponse(byte[] byArray) throws ZebraIllegalArgumentException {
        Map<String, String> map = null;
        try {
            map = StringUtilities.convertKeyValueJsonToMap(byArray);
        }
        catch (Exception exception) {
            throw new ZebraIllegalArgumentException("Error processing response from device: [" + new String(byArray) + "]");
        }
        return map;
    }

    public static boolean isValidJson(byte[] byArray) {
        boolean bl = false;
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonParser jsonParser = objectMapper.getFactory().createParser(byArray);
            objectMapper.readTree(byArray);
            bl = jsonParser.nextToken() != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static byte[] buildSetCommand(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder("{}");
        try {
            String string = JacksonObjectMapperFactory.getInstance().writeValueAsString(map);
            stringBuilder.append(string);
        }
        catch (JsonProcessingException jsonProcessingException) {
            jsonProcessingException.printStackTrace();
        }
        return stringBuilder.toString().getBytes();
    }

    public static boolean isValidJson(String string) {
        boolean bl = false;
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonFactory jsonFactory = objectMapper.getFactory();
            objectMapper.readTree(jsonFactory.createParser(string));
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }
}

