package entity.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for device_destory_detail
 * 销毁退回详情
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update device_destory_detail set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@ApiModel("销毁退回详情")
public class DeviceDestroyDetail {

	/**
	* 主键id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty(name = "主键id")
	private Integer id;
	/**
	* 销毁账单id
	*/
	@ApiModelProperty(value = "销毁账单id")
	private Integer destoryBillId;
	/**
	* 销毁标题
	*/
	@ApiModelProperty(value = "销毁标题")
	private String title;
	/**
	* 申请文号
	*/
	@ApiModelProperty(value = "申请文号")
	private String applyNumber;
	/**
	* 批复文号
	*/
	@ApiModelProperty(value = "批复文号")
	private String replayNumber;
	/**
	* 发件单位
	*/
	@ApiModelProperty(value = "发件单位")
	private String sendUnit;
	/**
	* 收件单位
	*/
	@ApiModelProperty(value = "收件单位")
	private String receiveUnit;
	/**
	* 发送时间
	*/
	@ApiModelProperty(value = "发送时间")
	private Date sendTime;
	/**
	* 接收时间
	*/
	@ApiModelProperty(value = "接收时间")
	private Date receiveTime;
	/**
	* 发件方id(A岗位)
	*/
	@ApiModelProperty(value = "发件方id(A岗位)")
	private Integer sendUserAId;
	/**
	* 发件方id(B岗位)
	*/
	@ApiModelProperty(value = "发件方id(B岗位)")
	private Integer sendUserBId;
	/**
	* 收件方id(A岗位)
	*/
	@ApiModelProperty(value = "收件方id(A岗位)")
	private Integer receiveUserAId;
	/**
	* 收件方id(B岗位)
	*/
	@ApiModelProperty(value = "收件方id(B岗位)")
	private Integer receiveUserBId;
	/**
	* 出库附件文件名
	*/
	@ApiModelProperty(value = "出库附件文件名")
	private String fileName;
	/**
	* 出库附件文件地址URL
	*/
	@ApiModelProperty(value = "出库附件文件地址URL")
	private String fileUrl;
	/**
	* 账单文件名
	*/
	@ApiModelProperty(value = "账单文件名")
	private String billFileName;
	/**
	* 账单文件地址URL
	*/
	@ApiModelProperty(value = "账单文件地址URL")
	private String billFileUrl;
	/**
	* 待销毁装备退回状态(1:销毁出库待审核,2:出库审核失败,3:待销毁装备退回中,4:退回接收待审核,5:退回接收审核失败,6:待销毁装备退回成功)
	*/
	@ApiModelProperty(value = "待销毁装备退回状态(1:销毁出库待审核,2:出库审核失败,3:待销毁装备退回中,4:退回接收待审核,5:退回接收审核失败,6:待销毁装备退回成功)")
	private Integer sendBackStatus;
	/**
	* 待销毁装备退回数量
	*/
	@ApiModelProperty(value = "待销毁装备退回数量")
	private Integer sendBackCount;
	/**
	* 已出库装备数量
	*/
	@ApiModelProperty(value = "已出库装备数量")
	private Integer sendedCount;
	/**
	* 已接收装备数量
	*/
	@ApiModelProperty(value = "已接收装备数量")
	private Integer receiveCount;
	/**
	* 出库检查详情(装备主键id+核对结果(0缺失1无误3不匹配,字符x作为分隔符)),例如10x21x32,意为主键id为1的装备缺失,为2的无误,为3的不匹配
	*/
	@ApiModelProperty(value = "出库检查详情(装备主键id+核对结果(0缺失1无误3不匹配,字符x作为分隔符)),例如10x21x32,意为主键id为1的装备缺失,为2的无误,为3的不匹配")
	private String sendCheckDetail;
	/**
	* 出库检查结果
	*/
	@ApiModelProperty(value = "出库检查结果")
	private String sendCheckResult;
	/**
	* 接收方入库检查详情(装备主键id+核对结果(0缺失1无误3不匹配,字符x作为分隔符)),例如10x21x32,意为主键id为1的装备缺失,为2的无误,为3的不匹配
	*/
	@ApiModelProperty(value = "接收方入库检查详情(装备主键id+核对结果(0缺失1无误3不匹配,字符x作为分隔符)),例如10x21x32,意为主键id为1的装备缺失,为2的无误,为3的不匹配")
	private String receiveCheckDetail;
	/**
	* 接收方检查结果
	*/
	@ApiModelProperty(value = "接收方检查结果")
	private String receiveCheckResult;
	/**
	* 创建用户id
	*/
	@CreatedBy
	@ApiModelProperty(value = "创建用户id")
	private Integer createUserId;
	/**
	* 创建时间
	*/
	@CreatedDate
	@ApiModelProperty(value = "创建时间")
	private Date createTime;
	/**
	* 更新用户id
	*/
	@LastModifiedBy
	@ApiModelProperty(value = "更新用户id")
	private Integer updateUserId;
	/**
	* 更新时间
	*/
	@LastModifiedDate
	@ApiModelProperty(value = "更新时间")
	private Date updateTime;
	/**
	* 删除标记(0:未删除，1:已删除)
	*/
	@ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
	private Integer deleteTag;
	/**
	* 预留字段1
	*/
	@ApiModelProperty(value = "预留字段1")
	private String var1;
	/**
	* 预留字段2
	*/
	@ApiModelProperty(value = "预留字段2")
	private String var2;

}
