package entity.vo;

import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class DeviceDestoryDetailSelectVo
 * @packageName com.tykj.dev.device.destory.subject.entity.vo
 **/
@Data
@ApiModel("销毁详情查询类")
public class DeviceDestroyDetailResultVo {

    @ApiModelProperty(value = "发起人ID",example = "1")
    private Integer startUserId;

    @ApiModelProperty(value = "审核人ID",example = "1")
    private Integer confirmUserId;


    @ApiModelProperty(value = "发起人",example = "1")
    private String startUser;

    @ApiModelProperty(value = "审核人",example = "1")
    private String confirmUser;

    @ApiModelProperty(value = "销毁状态(0:销毁装备出库待审核,1:销毁装备出库审核失败,2:已销毁)")
    private Integer destoryStatus ;

    @ApiModelProperty(value = "出库附件文件名")
    private String fileName ;

    @ApiModelProperty(value = "出库附件文件地址URL")
    private String fileUrl ;

    @ApiModelProperty(value = "文号")
    private String docNumber;

    @ApiModelProperty(value = "创建时间")
    private java.util.Date createTime ;

    @ApiModelProperty(value = "承办人")
    private String undertaker ;

    @ApiModelProperty(value = "主管领导")
    private String leader ;

    @ApiModelProperty(value = "监销人")
    private String supervisor ;

    @ApiModelProperty(value = "名称")
    private String name ;

    @ApiModelProperty(value = "型号")
    private String model ;

    @ApiModelProperty(value = "销毁单位")
    private String unit ;

    @ApiModelProperty(value = "销毁装备列表",example = "1")
    private List<DeviceLibrary> devices = new ArrayList<>();

    public DeviceDestroyDetailResultVo(Integer startUserId, Integer confirmUserId, String startUser, String confirmUser, Integer destoryStatus, String fileName, String fileUrl, String docNumber, Date createTime, String undertaker, String leader, String supervisor, String name, String model, String unit, List<DeviceLibrary> devices) {
        this.startUserId = startUserId;
        this.confirmUserId = confirmUserId;
        this.startUser = startUser;
        this.confirmUser = confirmUser;
        this.destoryStatus = destoryStatus;
        this.fileName = fileName;
        this.fileUrl = fileUrl;
        this.docNumber = docNumber;
        this.createTime = createTime;
        this.undertaker = undertaker;
        this.leader = leader;
        this.supervisor = supervisor;
        this.name = name;
        this.model = model;
        this.unit = unit;
        this.devices = devices;
    }
}
