package com.tykj.dev.device.library.subject.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author dengdiyi
 * @description 日志存储类
 */
@AllArgsConstructor
@Data
@NoArgsConstructor
public class LogVo {

    /**
     * 装备主键Id
     */
    private Integer deviceId;

    /**
     * 任务主键Id
     */
    private Integer taskId;

    /**
     * 操作描述
     */
    private String remark;

    /**
     * 相关附件信息(Ǵ作为每个附件分隔符,Ǒ作为附件内部分隔符,例如name1Ǒurl1Ǒ配发单Ǵname2Ǒurl2Ǒ入库确认单Ǵ)
     */
    private String fileDetail;

    /**
     * 日志类型(默认0为装备日志,1为设备日志)
     */
    private Integer type = 0;

}
