package entity.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class DeviceRetierResultVo
 * @packageName com.tykj.dev.device.retired.subject.entity.vo
 **/
@ApiModel("退装-列装详情")
@Data
public class DeviceRetiredResultVo {

    @ApiModelProperty(value = "id")
    private Integer id;

    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "型号",example = "xxx-1")
    private String model;

    @ApiModelProperty(value = "经办人/主管领导",example = "密级")
    private Integer secretLevel;

    @ApiModelProperty(value = "类型",example = "1")
    private Integer type;

    @ApiModelProperty(value = "数量",example = "1")
    private Long count;

    @ApiModelProperty(value = "数量",example = "1")
    private List<DeviceRetiredResultVo> childNodes = new ArrayList<>();
}
