package com.tykj.dev.device.selfcheck.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.library.repository.DeviceLibraryDao;
import com.tykj.dev.device.library.service.DeviceLibraryService;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.selfcheck.service.SelfCheckBillService;
import com.tykj.dev.device.selfcheck.subject.domin.SelfCheckBill;
import com.tykj.dev.device.selfcheck.subject.vo.*;
import com.tykj.dev.device.task.repository.TaskDao;
import com.tykj.dev.device.task.service.TaskService;
import com.tykj.dev.device.task.subject.bto.TaskBto;
import com.tykj.dev.device.task.subject.common.StatusEnum;
import com.tykj.dev.device.task.subject.domin.Task;
import com.tykj.dev.device.user.subject.service.UserPublicService;
import com.tykj.dev.device.user.util.UserUtils;
import com.tykj.dev.misc.utils.ResultUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @author dengdiyi
 */
@RestController
@RequestMapping(value = "/selfCheck")
@AutoDocument
@Api(tags = "自查模块",description = "自查接口")
public class SelfCheckController {

    @Autowired
    private SelfCheckBillService selfExaminationBillService;

    @Autowired
    private UserUtils userUtils;

    @Autowired
    private TaskService taskService;

    @Autowired
    private TaskDao taskDao;

    @Autowired
    private DeviceLibraryService deviceLibraryService;

    @Autowired
    private DeviceLibraryDao deviceLibraryDao;

//    @Autowired
//    private DeviceLogService deviceLogService;
//
//    @Autowired
//    private DeviceLogDao deviceLogDao;

    @Autowired
    private UserPublicService userPublicService;

    @ApiOperation(value = "装备比较",notes = "可以通过这个接口发起比较装备")
    @PostMapping(value = "/compare")
    public ResponseEntity<CompareResultVo> compare(@RequestBody CompareVo compareVo){
        List<Integer> list = compareVo.getDeivceIdList();
        List<String> list1 = new ArrayList<>();
        List<DeviceLibrary> deviceLibraryEntities = new ArrayList<>();
        List<DeviceLibrary> newList = new ArrayList<>();
        List<DeviceLibrary> resultList = new ArrayList<>();
        for (Integer id:list) {
            DeviceLibrary d = deviceLibraryService.getOne(id);
            list1.add(d.getRfidCardId());
            deviceLibraryEntities.add(d);
        }
        List<String> list2 = compareVo.getRfidResultList();
        list1.retainAll(list2);
        for (DeviceLibrary d:deviceLibraryEntities) {
            if (list1.contains(d.getRfidCardId())){
                d.setCheckResult(1);
            }
            else {
                d.setCheckResult(0);
            }
        }
        for (String s:list2) {
            if (!list1.contains(s)){
                List<DeviceLibrary> d = deviceLibraryDao.getAllByRfidCardId(s);
                if (d.size()>0) {
                    for (DeviceLibrary deviceLibraryEntity:d) {
                        deviceLibraryEntity.setCheckResult(2);
                        resultList.add(deviceLibraryEntity);
                    }
                }
                if (d.isEmpty()){
                    DeviceLibrary deviceLibraryEntity = new DeviceLibrary();
                    deviceLibraryEntity.setCheckResult(2);
                    deviceLibraryEntity.setSeqNumber("-");
                    deviceLibraryEntity.setName("-");
                    deviceLibraryEntity.setType(0);
                    deviceLibraryEntity.setModel("-");
                    deviceLibraryEntity.setRfidSurfaceId("-");
                    deviceLibraryEntity.setProdNumber("-");
                    deviceLibraryEntity.setRfidCardId(s);
                    newList.add(deviceLibraryEntity);
                }
            }
        }
        for (DeviceLibrary d:deviceLibraryEntities) {
            if (d.getCheckResult()==0){
                resultList.add(d);
            }
        }
        for (DeviceLibrary d:deviceLibraryEntities) {
            if (d.getCheckResult()==1){
                resultList.add(d);
            }
        }
        CompareResultVo compareResultVo = new CompareResultVo();
        compareResultVo.setNewList(newList);
        compareResultVo.setResultList(resultList);
        return ResultUtil.success(compareResultVo);
    }

    @ApiOperation(value = "发起自查业务",notes = "可以通过这个接口发起自查业务")
    @PostMapping(value = "/addBill")
    public ResponseEntity<SelfCheckBill> addSelfExaminationBill(@RequestBody SelfExaminationSaveVo selfExaminationSaveVo) {
        //添加账单
        SelfCheckBill selfExaminationBillEntity = selfExaminationSaveVo.toDo();
        selfExaminationBillEntity.setTitle(userUtils.getCurrentUserUnitName()+"发起的自查任务");
        selfExaminationBillEntity.setUseraId(userUtils.getCurrentUserId());
        selfExaminationBillEntity.setCheckUnit(userUtils.getCurrentUserUnitName());
        selfExaminationBillEntity.setCreateUnitId(userUtils.getCurrentUnitId());
        if (selfExaminationSaveVo.getNewDeviceList()!=null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(".");
            for (String s : selfExaminationSaveVo.getNewDeviceList()) {
                stringBuffer.append(s);
                stringBuffer.append(".");
            }
            selfExaminationBillEntity.setNewDeviceDetail(stringBuffer.toString());
        }
        SelfCheckBill selfExaminationBillEntity1 = selfExaminationBillService.addEntity(selfExaminationBillEntity);
        Integer userId = userUtils.getCurrentUserId();
        String deviceIdDetail = selfExaminationBillEntity.getCheckDetail();
        String[] strings = deviceIdDetail.split("x");
        //发起任务
        List<Integer> userIds = new ArrayList<>();
        userIds.add(userId);
        userIds.add(selfExaminationBillEntity1.getUserbId());
        TaskBto taskBto = new TaskBto(StatusEnum.SELF_CHECK_CONFIRM.id,"自查业务",null,".",selfExaminationBillEntity1.getId(),4,userUtils.getCurrentUnitId(),1,null,userIds);
        Task saveEntity = taskService.start(taskBto);
//        for (String s:strings) {
//            if (s.length()>=2) {
//                Integer id = Integer.parseInt(s.substring(0, s.length() - 1));
//                LogVo bussinessLogVo = new LogVo();
//                bussinessLogVo.setDeviceId(id);
//                bussinessLogVo.setFileDetail("Ǵ");
//                bussinessLogVo.setRemark("发起自查");
//                bussinessLogVo.setTaskId(saveEntity.getId());
//                deviceLogService.addLog(bussinessLogVo);
//            }
//        }
        return ResultUtil.success(selfExaminationBillEntity1);
    }

    @ApiOperation(value = "自查审核",notes = "可以通过这个接口自查审核")
    @PatchMapping(value = "/selfExaminationConfirm")
    public ResponseEntity<String> selfExaminationConfirm(@RequestBody SelfExaminationConfirmVo selfExaminationConfirmVo){
        TaskBto taskBto = taskService.get(selfExaminationConfirmVo.getTaskId());
        SelfCheckBill selfExaminationBillEntity = selfExaminationBillService.getOne(taskBto.getBillId());
        String deviceIdDetail = selfExaminationBillEntity.getCheckDetail();
        String[] strings = deviceIdDetail.split("x");
        //审核通过，改变账单和任务状态，发起确认的任务
        if (selfExaminationConfirmVo.getStatus()==0){
            taskService.update(taskService.moveToEnd(taskBto));
            selfExaminationBillEntity.setCheckStatus(2);
            selfExaminationBillService.update(selfExaminationBillEntity);
//            for (String s:strings) {
//                if (s.length()>=2) {
//                    Integer id = Integer.parseInt(s.substring(0, s.length() - 1));
//                    LogVo bussinessLogVo = new LogVo();
//                    bussinessLogVo.setDeviceId(id);
//                    bussinessLogVo.setFileDetail("Ǵ");
//                    bussinessLogVo.setRemark("自查审核成功");
//                    bussinessLogVo.setTaskId(taskBto.getId());
//                    deviceLogService.addLog(bussinessLogVo);
//                }
//            }
            return ResultUtil.success("审核通过自查完成");
        }
        //审核不通过，改变账单和任务状态
        if (selfExaminationConfirmVo.getStatus()==1){
            taskService.update(taskService.moveToArchive(taskBto));
            selfExaminationBillEntity.setCheckStatus(1);
            selfExaminationBillService.update(selfExaminationBillEntity);
//            for (String s:strings) {
//                if (s.length()>=2) {
//                    Integer id = Integer.parseInt(s.substring(0, s.length() - 1));
//                    LogVo bussinessLogVo = new LogVo();
//                    bussinessLogVo.setDeviceId(id);
//                    bussinessLogVo.setFileDetail("Ǵ");
//                    bussinessLogVo.setRemark("自查审核失败");
//                    bussinessLogVo.setTaskId(taskBto.getId());
//                    deviceLogService.addLog(bussinessLogVo);
//                }
//            }
            return ResultUtil.success("自查审核失败");
        }
        else {
            return ResultUtil.failed("status只能为0或1");
        }
    }

    @ApiOperation(value = "查询自查任务",notes = "可以通过这个接口查询自查任务")
    @PostMapping(value = "/summary")
    public ResponseEntity<Page<SelfCheckBill>> selectSelfExaminationBill(@RequestBody SelfExaminationSelectVo selfExaminationSelectVo){
        Page<SelfCheckBill> page = selfExaminationBillService.getPage(selfExaminationSelectVo,selfExaminationSelectVo.getPageable());
        for (SelfCheckBill s:page.getContent()) {
            s.setCreateUnit(userPublicService.findByUnitsToname(s.getCreateUnitId()));
            String user = userPublicService.getOne(s.getUseraId()).getName();
            String user2 = userPublicService.getOne(s.getUserbId()).getName();
            String user3 = userPublicService.getOne(s.getCreateUserId()).getName();
            s.setCheckUser(user);
            s.setConfirmUser(user2);
            s.setCreateUser(user3);
        }
        return ResultUtil.success(page);
    }

//    @ApiOperation(value = "查询自查任务详情",notes = "可以通过这个接口查询自查任务详情")
//    @GetMapping(value = "/detail/{id}")
//    public ResultObj selectDetail(@PathVariable("id") int id){
//        List<Object> list = new ArrayList<>();
//        SelfCheckBill selfExaminationBillEntity = selfExaminationBillService.getOne(id);
//        if (selfExaminationBillEntity.getUserAId()!=0) {
//            selfExaminationBillEntity.setCheckUser(userPublicService.getOne(selfExaminationBillEntity.getUserAId()).getName());
//        }
//        if (selfExaminationBillEntity.getUserBId()!=0) {
//            selfExaminationBillEntity.setConfirmUser(userPublicService.getOne(selfExaminationBillEntity.getUserBId()).getName());
//        }
//        list.add(selfExaminationBillEntity);
//        String str3 = selfExaminationBillEntity.getCheckDetail();
//        String str4 = selfExaminationBillEntity.getNewDeviceDetail();
//        String[] split = str3.split("x");
//        if (str4!=null) {
//            String[] split2 = str4.split("\\.");
//            List<DeviceLibrary> newDeviceList = new ArrayList<>();
//            for (String rfid:split2){
//                if (rfid.length()>0){
//                    DeviceLibrary d = new DeviceLibrary();
//                    d.setCheckResult(2);
//                    d.setSeqNumber("-");
//                    d.setName("-");
//                    d.setType(0);
//                    d.setRfidSurfaceId("-");
//                    d.setProdNumber("-");
//                    d.setRfidCardId(rfid);
//                    newDeviceList.add(d);
//                }
//            }
//            list.add(newDeviceList);
//        }
//        if (str4==null){
//            List<DeviceLibrary> newDeviceList = new ArrayList<>();
//            list.add(newDeviceList);
//        }
//        List<DeviceLibrary> libraryEntities1 = new ArrayList<>();
//        for (String s:split) {
//            if (s.length()>=2) {
//                Integer i = Integer.parseInt(s.substring(0, s.length() - 1));
//                Integer checkResult = Integer.parseInt(s.substring(s.length()-1));
//                DeviceLibrary deviceLibraryEntity = deviceLibraryService.getOne(i);
//                deviceLibraryEntity.setCheckResult(checkResult);
//                libraryEntities1.add(deviceLibraryEntity);
//            }
//        }
//        list.add(libraryEntities1);
//        List<TaskEntity> taskEntity = taskDao.findAllByBillIdAndBussinessType(id,4);
//        if (taskEntity.size()==1){
//            List<DeviceLogEntity> logEntities = deviceLogDao.getAllByTaskId(taskEntity.get(0).getId());
//            for (DeviceLogEntity d:logEntities) {
//                d.setUser(userPublicService.getOne(d.getUserId()).getName());
//                d.setUnit(userPublicService.findUnitsNameByUserId(d.getUserId()));
//                String[] strings = d.getFileDetail().split("Ǵ");
//                List<FileVo> fileVos = new ArrayList<>();
//                if (strings.length>0){
//                    for (String s:strings) {
//                        if (s.length()>0){
//                            String[] strings1 = s.split("Ǒ");
//                            if ("".equals(strings1[0])&&strings1.length==4){
//                                FileVo fileVo = new FileVo();
//                                fileVo.setFileName(strings1[1]);
//                                fileVo.setFileUrl(strings1[2]);
//                                fileVo.setTitle(strings1[3]);
//                                fileVos.add(fileVo);
//                            }
//                            if (!"".equals(strings1[0])&&strings1.length==3){
//                                FileVo fileVo = new FileVo();
//                                fileVo.setFileName(strings1[0]);
//                                fileVo.setFileUrl(strings1[1]);
//                                fileVo.setTitle(strings1[2]);
//                                fileVos.add(fileVo);
//                            }
//                        }
//                    }
//                }
//                d.setFileVoList(fileVos);
//            }
//            list.add(logEntities);
//        }
//        return new ResultObj(list,"查询成功");
//    }

}
