package com.tykj.dev.device.task.subject.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Transient;
import java.util.Date;
import java.util.List;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class TaskUserVo {

    @ApiModelProperty(value = "主键id")
    private Integer id;

    @ApiModelProperty(value = "任务状态")
    private Integer billStatus;

    @ApiModelProperty(value = "任务标题")
    private String title;

    @ApiModelProperty(value = "父任务主键id")
    private Integer parentTaskId;

    @ApiModelProperty(value = "所有节点任务id组合,例如.1.2.,意为从根节点到当前节点所经历的节点为1和2")
    private String nodeIdDetail;

    @ApiModelProperty(value = "对应账单ID")
    private Integer billId;

    @ApiModelProperty(value = "业务类型主键id")
    private Integer businessType;

    @ApiModelProperty(value = "所属单位")
    private Integer ownUnit;

    @ApiModelProperty(value = "数字类型，用于代表指针目前的下标")
    private Integer currentPoint;

    @ApiModelProperty(value = "自定义信息，针对不同业务需要保存一些自定信息")
    private String customInfo;

    @ApiModelProperty(value = "置顶用户id的List")
    private List<Integer> topFlagDetailList;

    @ApiModelProperty(value = "阅读过用户id的List")
    private List<Integer> userReadDetailList;

    @ApiModelProperty(value = "工作涉及人员id")
    private List<Integer> involveUserIdList;

    @ApiModelProperty(value = "跟踪时间")
    @Transient
    private String userTime;

    @ApiModelProperty(value = "跟踪时间日期")
    @Transient
    private Date userTimeDate;

    @ApiModelProperty(value = "处理人")
    @Transient
    private String processingUser;

    @ApiModelProperty(value = "待办时间")
    @Transient
    private String trackingTime;

    @ApiModelProperty(value = "待办时间日期")
    @Transient
    private Date trackingTimeDate;

    @ApiModelProperty(value = "发起单位")
    @Transient
    private String startUnit;

    @ApiModelProperty(value = "是否阅读(0:未读，1:已读)")
    @Transient
    private Integer isRead = 0;

    @ApiModelProperty(value = "是否置顶(0:是，1:不是)")
    @Transient
    private Integer isTop = 0;

    @ApiModelProperty(value = "状态描述")
    private String status;
}
