package com.tykj.dev.rfid.entity.vo;

import com.tykj.dev.misc.base.CustomPage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("库房报警记录查询类")
public class LibraryWarningLogSelectVo extends CustomPage {

    @ApiModelProperty(value = "告警单位")
    private String unit;

    @ApiModelProperty(value = "告警类型(0:入库异常,1:出库异常,2:盘点异常)")
    private List<Integer> warningType;

    @ApiModelProperty(value = "模糊查询")
    private String content;

    @ApiModelProperty(value = "是否处理 0为未处理 1为已处理")
    private Integer warningHandle;

    @ApiModelProperty(value = "异常情况（正常 新增 缺失）")
    private String inventoryResults;

    @ApiModelProperty(value = "告警状态 0为正常 1为异常 ")
    private Integer status;

    @ApiModelProperty("时间 0为 本年 1为本月 2为本周 3为本日")
    private Integer time;

    @ApiModelProperty("查询开始时间")
    private Date startTime;

    @ApiModelProperty("查询结束时间")
    private Date endTime;


}
